-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema runner2project
--

-- CREATE DATABASE IF NOT EXISTS runner2project;
-- USE runner2project;

--
-- Definition of table `catalog`
--

DROP TABLE IF EXISTS `catalog`;
CREATE TABLE `catalog` (
  `idcatalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_catalog_idsuper_catalog` int(11) NOT NULL,
  `catalog_num` int(11) NOT NULL,
  `catalog_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idcatalog`),
  UNIQUE KEY `idx1_catalog` (`super_catalog_idsuper_catalog`,`catalog_num`),
  KEY `fk_catalog_super_catalog1_idx` (`super_catalog_idsuper_catalog`),
  CONSTRAINT `fk_catalog_super_catalog1` FOREIGN KEY (`super_catalog_idsuper_catalog`) REFERENCES `super_catalog` (`idsuper_catalog`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `catalog`
--

/*!40000 ALTER TABLE `catalog` DISABLE KEYS */;
INSERT INTO `catalog` (`idcatalog`,`super_catalog_idsuper_catalog`,`catalog_num`,`catalog_code`,`description`) VALUES 
 (1,3,0,'S/A','Sin Asignar'),
 (2,2,0,'Public','Público'),
 (3,1,0,'S/A','Sin Asignar'),
 (4,4,0,'Days','Días'),
 (5,4,1,'Hours','Horas'),
 (6,5,0,'No','No'),
 (7,5,1,'Yes','Sí'),
 (8,6,0,'No','No'),
 (9,6,1,'Yes','Sí'),
 (10,7,0,'Public','Pública'),
 (11,8,0,'S/A','Sin Asgnar'),
 (12,9,0,'S/A','Sin Asignar'),
 (13,10,0,'Sí','Tarea seleccionada (Pinada)'),
 (14,11,0,'not','No'),
 (15,11,1,'yes','Sí'),
 (16,12,5,'5 %','5 %'),
 (17,12,10,'10 %','10 %'),
 (18,12,15,'15 %','15 %'),
 (19,12,20,'20 %','20 %'),
 (20,12,25,'25 %','25 %'),
 (21,12,0,'0 %','0 %'),
 (22,12,30,'30 %','30 %'),
 (23,12,35,'35 %','35 %'),
 (24,12,40,'40 %','40 %'),
 (25,12,45,'45 %','45 %'),
 (26,12,50,'50 %','50 %'),
 (27,12,55,'55 %','55 %'),
 (28,12,60,'60 %','60 %'),
 (29,12,65,'65 %','65 %'),
 (30,12,70,'70 %','70 %'),
 (31,12,75,'75 %','75 %'),
 (32,12,80,'80 %','80 %'),
 (33,12,85,'85 %','85 %'),
 (34,12,90,'90 %','90 %'),
 (35,12,95,'95 %','95 %'),
 (37,12,100,'100 %','100 %'),
 (38,2,1,'Company','Acceso a todos los de la Compañía'),
 (39,2,2,'Departament','Acceso a todos los del Departamento'),
 (40,2,3,'Owner Project','Acceso sólo al Propietario'),
 (41,2,4,'Owner + Owner Task','Acceso a Propietario y los propietarios de Tareas'),
 (42,7,1,'Company','Acceso a todos los de la Compañía'),
 (43,7,2,'Departament','Acceso a los del Departamento'),
 (44,7,3,'Owner Project','Acceso a propietario del Proyecto'),
 (45,7,4,'Owner Task+Proj.','Acceso a propietario de Tarea y Proyecto'),
 (46,13,0,'S/A','Sin Asignar'),
 (47,14,0,'To future','A futuro'),
 (48,14,1,'Ok','En fecha'),
 (49,14,2,'Delayed','Retrasado'),
 (50,14,3,'Finished','Terminada');
/*!40000 ALTER TABLE `catalog` ENABLE KEYS */;


--
-- Definition of table `companies`
--

DROP TABLE IF EXISTS `companies`;
CREATE TABLE `companies` (
  `company_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `phone1` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `address1` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `address2` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `city` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `state` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `zip` varchar(11) COLLATE utf8_unicode_ci DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `primary_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `owner` int(10) NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom` longtext COLLATE utf8_unicode_ci,
  `private` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`company_id`),
  KEY `company_name` (`name`),
  KEY `company_owner` (`owner`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `companies`
--

/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` (`company_id`,`name`,`phone1`,`phone2`,`fax`,`address1`,`address2`,`city`,`state`,`zip`,`country`,`primary_url`,`owner`,`description`,`email`,`custom`,`private`,`type`) VALUES 
 (0,'Sin definir',' ',' ',' ',' ','',' ',' ',' ',' ','',1,' Este es un \"cajón de sastre\" para asignar aquello que no es de ningua de las Empresas o Compañias.','',' ',0,0),
 (3,'Company 1','','','','','','','','','','',1,'Pruebas','','',0,0),
 (4,'Company 2','','','','','','','','','','',1,'','','',0,0);
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;


--
-- Definition of table `config`
--

DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` (
  `config_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `group` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `config_name` (`name`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `config`
--

/*!40000 ALTER TABLE `config` DISABLE KEYS */;
INSERT INTO `config` (`config_id`,`name`,`value`,`group`,`type`) VALUES 
 (1,'name_application','PHPRunner - Project','','0'),
 (2,'logo_application','logo1','','0'),
 (3,'hours_a_day','8.00','','0'),
 (4,'free_weekend','yes','','0'),
 (5,'start_time_day','08:00:00','','0'),
 (6,'end_time_day','17:00:00','','0'),
 (7,'update_dates_by_dependent','yes','','0');
/*!40000 ALTER TABLE `config` ENABLE KEYS */;


--
-- Definition of table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
CREATE TABLE `contacts` (
  `contact_id` int(10) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `display_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `job` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address1` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address2` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zip` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` mediumtext COLLATE utf8_unicode_ci,
  `private` int(10) unsigned DEFAULT '0',
  `updatekey` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lastupdate` datetime DEFAULT NULL,
  PRIMARY KEY (`contact_id`),
  KEY `contact_first_name` (`first_name`),
  KEY `contact_last_name` (`last_name`),
  KEY `contact_updatekey` (`updatekey`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `contacts`
--

/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` (`contact_id`,`first_name`,`last_name`,`display_name`,`title`,`birthday`,`job`,`type`,`email`,`phone`,`address1`,`address2`,`city`,`state`,`zip`,`country`,`notes`,`private`,`updatekey`,`lastupdate`) VALUES 
 (2,'Fernando','Humanes','Fernando Humanes','Diseñador y Desarrollador','1956-06-10','','0','info@fhumanes.com','','','','','','','','',0,'admin','2019-07-23 20:44:44');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;


--
-- Definition of table `departments`
--

DROP TABLE IF EXISTS `departments`;
CREATE TABLE `departments` (
  `dept_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `companies_company_id` int(10) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `desc` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`dept_id`),
  KEY `dept_name` (`name`),
  KEY `dept_type` (`type`),
  KEY `fk_departments_companies1_idx` (`companies_company_id`),
  CONSTRAINT `fk_departments_companies1` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Department heirarchy under a company';

--
-- Dumping data for table `departments`
--

/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
INSERT INTO `departments` (`dept_id`,`companies_company_id`,`name`,`phone`,`fax`,`desc`,`email`,`type`) VALUES 
 (1,3,'Departament 1.1','','','descripción','',0),
 (2,4,'Departament 2.1','','','','',0);
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;


--
-- Definition of table `files`
--

DROP TABLE IF EXISTS `files`;
CREATE TABLE `files` (
  `file_id` int(10) NOT NULL AUTO_INCREMENT,
  `projects_project_id` int(10) DEFAULT NULL,
  `tasks_task_id` int(10) DEFAULT NULL,
  `description` varchar(100) NOT NULL DEFAULT '',
  `files_content` varchar(5000) NOT NULL,
  PRIMARY KEY (`file_id`),
  KEY `word` (`description`),
  KEY `fk_files_tasks1_idx` (`tasks_task_id`),
  KEY `fk_files_projects1_idx` (`projects_project_id`),
  CONSTRAINT `fk_files_projects1` FOREIGN KEY (`projects_project_id`) REFERENCES `projects` (`project_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_files_tasks1` FOREIGN KEY (`tasks_task_id`) REFERENCES `tasks` (`task_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `files`
--

/*!40000 ALTER TABLE `files` DISABLE KEYS */;
INSERT INTO `files` (`file_id`,`projects_project_id`,`tasks_task_id`,`description`,`files_content`) VALUES 
 (8,2,NULL,'Ejemplo de fichero /buho Invernal)','[{\"name\":\"files\\/buho invernal_rhi6gbe2.jpg\",\"usrName\":\"buho invernal.jpg\",\"size\":328465,\"type\":\"image\\/jpeg\",\"searchStr\":\"buho invernal.jpg,!:sStrEnd\"}]');
/*!40000 ALTER TABLE `files` ENABLE KEYS */;


--
-- Definition of table `holidays`
--

DROP TABLE IF EXISTS `holidays`;
CREATE TABLE `holidays` (
  `id_holidays` int(11) NOT NULL AUTO_INCREMENT,
  `holiday` date NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id_holidays`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `holidays`
--

/*!40000 ALTER TABLE `holidays` DISABLE KEYS */;
INSERT INTO `holidays` (`id_holidays`,`holiday`,`description`) VALUES 
 (1,'2022-01-06','Reyes'),
 (3,'2022-04-14','Jueves Santo'),
 (4,'2022-04-15','Viernes Santo'),
 (5,'2022-02-15','Semana Blanca (especial cálculo)'),
 (6,'2022-05-02','Día de la Comunidad'),
 (7,'2022-07-25','Santiago'),
 (8,'2022-08-15','Virgen de Agosto'),
 (9,'2022-10-12','Día de la hispanidad'),
 (10,'2022-11-01','Día de los santos difuntos'),
 (11,'2022-12-06','Día de la Constitución'),
 (12,'2022-12-08','Virgen de la Inmaculada'),
 (13,'2022-12-26','Navidad');
/*!40000 ALTER TABLE `holidays` ENABLE KEYS */;


--
-- Definition of table `project_audit`
--

DROP TABLE IF EXISTS `project_audit`;
CREATE TABLE `project_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` datetime NOT NULL,
  `ip` varchar(40) NOT NULL,
  `user` varchar(300) DEFAULT NULL,
  `table` varchar(300) DEFAULT NULL,
  `action` varchar(250) NOT NULL,
  `description` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=724 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `project_audit`
--

/*!40000 ALTER TABLE `project_audit` DISABLE KEYS */;
INSERT INTO `project_audit` (`id`,`datetime`,`ip`,`user`,`table`,`action`,`description`) VALUES 
 (1,'2019-07-22 20:41:30','::1','admin','users','login',''),
 (2,'2019-07-23 13:19:11','::1','admin','users','login',''),
 (3,'2019-07-23 13:19:35','::1','admin','users','logout',''),
 (4,'2019-07-23 13:19:44','::1','humanes','users','login',''),
 (5,'2019-07-23 13:20:43','::1','humanes','users','edit','---Keys\r\nuser_id : 4\r\n---Fields\r\nusername [old]: \r\nusername [new]: Fernando Humanes\r\n'),
 (6,'2019-07-23 14:38:57','::1','humanes','companies','edit','---Keys\r\ncompany_id : 0\r\n---Fields\r\ndescription [old]:  \r\ndescription [new]:  Este es un \"cajón de sastre\" para asignar aquello que no es de ningua de las Empresas o Compañias.\r\n'),
 (7,'2019-07-23 16:16:47','::1','humanes','companies','add','---Keys\r\ncompany_id : 3\r\n---Fields\r\nname [new]: Compañía 1\r\ndescription [new]: Pruebas\r\nprivate [new]: 0\r\nowner [new]: 1\r\n'),
 (8,'2019-07-23 16:56:51','::1','admin','users','login',''),
 (9,'2019-07-23 17:17:24','::1','admin','users','login',''),
 (10,'2019-07-23 17:35:59','::1','admin','departments','add','---Keys\r\ndept_id : 1\r\n---Fields\r\ncompanies_company_id [new]: 3\r\nname [new]: Departamento 1\r\ndesc [new]: descripción\r\ntype [new]: 0\r\n'),
 (11,'2019-07-23 18:10:51','::1','admin','users','logout',''),
 (12,'2019-07-23 18:11:51','::1','admin','users','login',''),
 (13,'2019-07-23 18:30:23','::1','admin','users','edit','---Keys\r\nuser_id : 4\r\n---Fields\r\ncompanies_company_id [old]: 0\r\ncompanies_company_id [new]: 3\r\nemail [old]: \r\nemail [new]: info@fhumanes.com\r\n'),
 (14,'2019-07-23 18:30:37','::1','admin','users','edit','---Keys\r\nuser_id : 4\r\n---Fields\r\ndepartments_dept_id [old]: \r\ndepartments_dept_id [new]: 1\r\n'),
 (15,'2019-07-23 20:40:16','::1','admin','contacts','add','---Keys\r\ncontact_id : 2\r\n---Fields\r\nfirst_name [new]: Fernando\r\nlast_name [new]: Humanes\r\ndisplay_name [new]: Fernando Humanes\r\nbirthday [new]: 1956-06-10\r\ntype [new]: 0\r\nemail [new]: info@fhumanes.com\r\nprivate [new]: 0\r\nupdatekey [new]: admin\r\nlastupdate [new]: 2019-07-23 20:39:35\r\n'),
 (16,'2019-07-23 20:44:44','::1','admin','contacts','edit','---Keys\r\ncontact_id : 2\r\n---Fields\r\ntitle [old]: \r\ntitle [new]: Diseñador y Desarrollador\r\nlastupdate [old]: 2019-07-23 20:39:35\r\nlastupdate [new]: 2019-07-23 20:44:44\r\n'),
 (17,'2019-07-23 20:53:05','::1','admin','config','add','---Keys\r\nconfig_id : 81\r\n---Fields\r\nname [new]: prueba\r\nvalue [new]: valor1\r\ntype [new]: 0\r\n'),
 (18,'2019-07-24 17:55:43','::1','admin','users','login',''),
 (19,'2019-07-24 18:19:38','::1','admin','users','logout',''),
 (20,'2019-07-24 18:19:56','::1','admin','users','failed login',''),
 (21,'2019-07-24 18:20:04','::1','admin','users','login',''),
 (22,'2019-07-24 18:34:15','::1','admin','users','login',''),
 (23,'2019-07-24 18:43:20','::1','admin','users','login',''),
 (24,'2019-07-24 18:58:44','::1','admin','projects','add','---Keys\r\nproject_id : 2\r\n---Fields\r\ncompanies_company_id [new]: 3\r\nname [new]: Ejemplo\r\nshort_name [new]: P19/001\r\nowner [new]: 1\r\nstart_date [new]: 2019-07-24 08:00:00\r\nend_date [new]: 2019-08-21 18:00:00\r\nstatus [new]: 0\r\ncolor_identifier [new]: #C90E9D\r\ncreator [new]: 1\r\nprivate [new]: 0\r\nactive [new]: 0\r\nproject_parent [new]: 0\r\nproject_updator [new]: 1\r\ncreated [new]: 2019-07-24 18:57:42\r\nupdated [new]: 2019-07-24 18:57:42\r\nend_date_adjusted_user [new]: 1\r\n'),
 (25,'2019-07-25 12:41:41','::1','admin','projects','edit','---Keys\r\nproject_id : 2\r\n---Fields\r\ncontacts [old]: \r\ncontacts [new]: 2\r\nupdated [old]: 2019-07-24 18:57:42\r\nupdated [new]: 2019-07-25 12:41:41\r\n'),
 (26,'2019-07-25 12:42:56','::1','admin','projects','edit','---Keys\r\nproject_id : 2\r\n---Fields\r\nname [old]: Ejemplo\r\nname [new]: Ejemplo del primer proyecto con el fin de hacer pruebas\r\nupdated [old]: 2019-07-25 12:41:41\r\nupdated [new]: 2019-07-25 12:42:55\r\n'),
 (27,'2019-07-25 12:57:27','::1','admin','tasks','add','---Keys\r\ntask_id : 1\r\n---Fields\r\nprojects_project_id [new]: 2\r\nname [new]: 1 .- Tarea 1\r\nmilestone [new]: 0\r\nstart_date [new]: 2019-07-25\r\nduration [new]: 10\r\nduration_type [new]: 0\r\nhours_worked [new]: 0\r\nend_date [new]: 2019-07-31\r\nstatus [new]: 0\r\npercent_complete [new]: 0\r\ndescription [new]: dedede\r\ncreator [new]: 1\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\naccess [new]: 0\r\nnotify [new]: 0\r\ncustom [new]: 0\r\ntype [new]: 0\r\nupdator [new]: 1\r\ncreated [new]: 2019-07-25\r\nupdated [new]: 2019-07-24\r\n'),
 (28,'2019-08-12 20:51:45','::1','admin','users','failed login',''),
 (29,'2019-08-12 20:51:51','::1','admin','users','login',''),
 (30,'2019-08-12 20:54:03','::1','admin','users','logout',''),
 (31,'2019-08-14 13:18:50','::1','admin','users','failed login',''),
 (32,'2019-08-14 13:19:20','::1','admin','users','login',''),
 (33,'2019-08-14 13:43:32','::1','admin','users','login',''),
 (34,'2019-08-14 14:40:04','::1','admin','tasks','add','---Keys\r\ntask_id : 2\r\n---Fields\r\nprojects_project_id [new]: 2\r\nname [new]: 2.- Tarea 2\r\nstart_date [new]: 2019-08-22 08:00:00\r\nduration [new]: 2\r\nduration_type [new]: 0\r\nhours_worked [new]: 0\r\nstatus [new]: 0\r\ndescription [new]: dedededede\r\ncreator [new]: 1\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\naccess [new]: 0\r\nnotify [new]: 0\r\ntype [new]: 0\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-14 14:38:40\r\nupdated [new]: 2019-08-14 14:38:40\r\n'),
 (35,'2019-08-14 14:43:43','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\npercent_complete [old]: \r\npercent_complete [new]: 0\r\nupdated [old]: 2019-08-14 14:38:40\r\nupdated [new]: 2019-08-14 14:43:30\r\n'),
 (36,'2019-08-14 14:44:24','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nend_date [old]: \r\nend_date [new]: 2019-08-26 08:00:00\r\nupdated [old]: 2019-08-14 14:43:30\r\nupdated [new]: 2019-08-14 14:43:57\r\n'),
 (37,'2019-08-14 14:47:21','::1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\ncustom [old]: 0\r\ncustom [new]:  \r\nupdated [old]: 2019-07-24 00:00:00\r\nupdated [new]: 2019-08-14 14:47:10\r\n'),
 (38,'2019-08-14 16:37:51','::1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nname [old]: 1 .- Tarea 1\r\nname [new]: 1.- Tarea 1\r\nupdated [old]: 2019-08-14 14:47:10\r\nupdated [new]: 2019-08-14 16:37:43\r\n'),
 (39,'2019-08-14 17:21:57','::1','admin','user_tasks','add','---Keys\r\nuser_task_id : 1\r\n---Fields\r\nusers_user_id [new]: 1\r\ntasks_task_id [new]: 1\r\ntype [new]: 0\r\nperc_assignment [new]: 100\r\nuser_task_priority [new]: 0\r\n'),
 (40,'2019-08-14 17:22:20','::1','admin','user_tasks','add','---Keys\r\nuser_task_id : 2\r\n---Fields\r\nusers_user_id [new]: 4\r\ntasks_task_id [new]: 1\r\ntype [new]: 0\r\nperc_assignment [new]: 100\r\nuser_task_priority [new]: 0\r\n'),
 (41,'2019-08-14 17:22:26','::1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nupdated [old]: 2019-08-14 16:37:43\r\nupdated [new]: 2019-08-14 17:22:26\r\n'),
 (42,'2019-08-14 17:43:17','::1','admin','files','add','---Keys\r\nfile_id : 1\r\n---Fields\r\nprojects_project_id [new]: 2\r\ndescription [new]: Imagen\r\nfiles_content [new]: [{\"name\":\"files\\/fhumanes2_qx74uf3f.png\",\"usrName\":\"fhumanes2.png\",\"size\":80426,\"type\":\"image\\/png\",\"searchStr\":\"fhumanes2.png,!:sStrEnd\"}]\r\n'),
 (43,'2019-08-14 17:54:55','::1','admin','user_task_pin','add','---Keys\r\nuser_task_pin_id : 1\r\n---Fields\r\nusers_user_id [new]: 1\r\ntasks_task_id [new]: 1\r\ntask_pinned [new]: 0\r\n'),
 (44,'2019-08-14 17:56:03','::1','admin','files','add','---Keys\r\nfile_id : 2\r\n---Fields\r\nprojects_project_id [new]: 2\r\ntasks_task_id [new]: 1\r\ndescription [new]: Prueba\r\nfiles_content [new]: [{\"name\":\"files\\/fhumanes2_i3q9jypy.png\",\"usrName\":\"fhumanes2.png\",\"size\":80426,\"type\":\"image\\/png\",\"searchStr\":\"fhumanes2.png,!:sStrEnd\"}]\r\n'),
 (45,'2019-08-14 18:33:02','::1','admin','config','add','---Keys\r\nconfig_id : 82\r\n---Fields\r\nname [new]: prueba2\r\nvalue [new]: valor2\r\ntype [new]: 0\r\n'),
 (46,'2019-08-14 18:42:42','::1','admin','users','logout',''),
 (47,'2019-08-14 18:42:49','::1','admin','users','login',''),
 (48,'2019-08-14 18:52:04','::1','admin','users','login',''),
 (49,'2019-08-14 19:04:58','::1','admin','config','edit','---Keys\r\nconfig_id : 82\r\n---Fields\r\nvalue [old]: valor2\r\nvalue [new]: 2valor2\r\n'),
 (50,'2019-08-14 19:05:04','::1','admin','users','logout',''),
 (51,'2019-08-14 19:05:11','::1','admin','users','login',''),
 (52,'2019-08-14 20:14:16','::1','admin','config','add','---Keys\r\nconfig_id : 83\r\n---Fields\r\nname [new]: hours_a_day\r\nvalue [new]: 8.00\r\ntype [new]: 0\r\n'),
 (53,'2019-08-14 20:16:13','::1','admin','config','add','---Keys\r\nconfig_id : 84\r\n---Fields\r\nname [new]: free_weekend\r\nvalue [new]: yes\r\ntype [new]: 0\r\n'),
 (54,'2019-08-14 20:17:06','::1','admin','config','add','---Keys\r\nconfig_id : 85\r\n---Fields\r\nname [new]: start_time_day\r\nvalue [new]: 08:00\r\ntype [new]: 0\r\n'),
 (55,'2019-08-14 20:17:22','::1','admin','config','edit','---Keys\r\nconfig_id : 85\r\n---Fields\r\nvalue [old]: 08:00\r\nvalue [new]: 08:00:00\r\n'),
 (56,'2019-08-14 20:18:24','::1','admin','config','add','---Keys\r\nconfig_id : 86\r\n---Fields\r\nname [new]: end_time_day\r\nvalue [new]: 17:00:00\r\ntype [new]: 0\r\n'),
 (57,'2019-08-14 20:22:05','::1','admin','config','edit','---Keys\r\nconfig_id : 1\r\n---Fields\r\nname [old]: prueba\r\nname [new]: name_application\r\nvalue [old]: valor1\r\nvalue [new]: PHPRunner - Project\r\n'),
 (58,'2019-08-14 20:23:47','::1','admin','users','logout',''),
 (59,'2019-08-14 20:23:54','::1','admin','users','login',''),
 (60,'2019-08-14 20:28:29','::1','admin','users','logout',''),
 (61,'2019-08-14 20:28:36','::1','admin','users','login',''),
 (62,'2019-08-14 20:30:20','::1','admin','config','edit','---Keys\r\nconfig_id : 2\r\n---Fields\r\nname [old]: prueba2\r\nname [new]: logo_application\r\nvalue [old]: 2valor2\r\nvalue [new]: logo1\r\n'),
 (63,'2019-08-14 20:43:57','::1','admin','projects','edit','---Keys\r\nproject_id : 2\r\n---Fields\r\ndepartments_dept_id [old]: \r\ndepartments_dept_id [new]: 1\r\nupdated [old]: 2019-07-25 12:42:55\r\nupdated [new]: 2019-08-14 20:43:57\r\n'),
 (64,'2019-08-14 23:02:53','::1','admin','users','login',''),
 (65,'2019-08-14 23:03:12','::1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nupdated [old]: 2019-08-14 17:22:26\r\nupdated [new]: 2019-08-14 23:03:12\r\n'),
 (66,'2019-08-14 23:12:47','::1','admin','users','login',''),
 (67,'2019-08-14 23:13:02','::1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nupdated [old]: 2019-08-14 23:03:12\r\nupdated [new]: 2019-08-14 23:13:02\r\n'),
 (68,'2019-08-14 23:15:28','::1','admin','users','login',''),
 (69,'2019-08-14 23:15:43','::1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nupdated [old]: 2019-08-14 23:13:02\r\nupdated [new]: 2019-08-14 23:15:43\r\n'),
 (70,'2019-08-14 23:24:25','::1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nupdated [old]: 2019-08-14 23:15:43\r\nupdated [new]: 2019-08-14 23:24:25\r\n'),
 (71,'2019-08-14 23:26:46','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nstart_date [old]: 2019-08-22 08:00:00\r\nstart_date [new]: 2019-06-04 08:00:00\r\nend_date [old]: 2019-08-26 08:00:00\r\nend_date [new]: 2019-06-06 08:00:00\r\nupdated [old]: 2019-08-14 14:43:57\r\nupdated [new]: 2019-08-14 23:26:46\r\n'),
 (72,'2019-08-14 23:30:11','::1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nstart_date [old]: 2019-07-25 00:00:00\r\nstart_date [new]: 2019-07-25 08:00:00\r\nend_date [old]: 2019-07-31 00:00:00\r\nend_date [new]: 2019-07-31 08:00:00\r\nupdated [old]: 2019-08-14 23:24:25\r\nupdated [new]: 2019-08-14 23:30:11\r\n'),
 (73,'2019-08-14 23:36:21','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nmilestone [old]: \r\nmilestone [new]: 0\r\nupdated [old]: 2019-08-14 23:26:46\r\nupdated [new]: 2019-08-14 23:36:21\r\n'),
 (74,'2019-08-14 23:36:38','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-14 23:36:21\r\nupdated [new]: 2019-08-14 23:36:38\r\n'),
 (75,'2019-08-14 23:38:32','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-14 23:36:38\r\nupdated [new]: 2019-08-14 23:38:32\r\n'),
 (76,'2019-08-14 23:46:16','::1','admin','tasks','add','---Keys\r\ntask_id : 3\r\n---Fields\r\nprojects_project_id [new]: 2\r\nparent [new]: 1\r\nname [new]: 1.1.- Tarea 1.1\r\nmilestone [new]: 0\r\nstart_date [new]: 2019-07-09 08:00:00\r\nduration [new]: 10\r\nduration_type [new]: 0\r\nhours_worked [new]: 0\r\nend_date [new]: 2019-07-23 08:00:00\r\nstatus [new]: 0\r\npercent_complete [new]: 0\r\ndescription [new]: frfrfr\r\ncreator [new]: 1\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\naccess [new]: 0\r\nnotify [new]: 0\r\ntype [new]: 0\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-14 23:44:53\r\nupdated [new]: 2019-08-14 23:44:53\r\n'),
 (77,'2019-08-14 23:52:20','::1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nupdated [old]: 2019-08-14 23:30:11\r\nupdated [new]: 2019-08-14 23:52:20\r\n'),
 (78,'2019-08-14 23:54:56','::1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nupdated [old]: 2019-08-14 23:52:20\r\nupdated [new]: 2019-08-14 23:54:56\r\n'),
 (79,'2019-08-14 23:55:23','::1','admin','tasks','delete','---Keys\r\ntask_id : 3\r\n---Fields\r\nprojects_project_id [old]: 2\r\nparent [old]: 1\r\nname [old]: 1.1.- Tarea 1.1\r\nmilestone [old]: 0\r\nstart_date [old]: 2019-07-09 08:00:00\r\nduration [old]: 10\r\nduration_type [old]: 0\r\nhours_worked [old]: 0\r\nend_date [old]: 2019-07-23 08:00:00\r\nstatus [old]: 0\r\npercent_complete [old]: 0\r\ndescription [old]: frfrfr\r\ncreator [old]: 1\r\norder [old]: 3\r\nlevel [old]: 2\r\ndynamic [old]: 0\r\naccess [old]: 0\r\nnotify [old]: 0\r\ntype [old]: 0\r\nupdator [old]: 1\r\ncreated [old]: 2019-08-14 23:44:53\r\nupdated [old]: 2019-08-14 23:44:53\r\n'),
 (80,'2019-08-14 23:56:27','::1','admin','tasks','add','---Keys\r\ntask_id : 4\r\n---Fields\r\nprojects_project_id [new]: 2\r\nparent [new]: 1\r\nname [new]: 1.1.- Tarea 1.1\r\nmilestone [new]: 0\r\nstart_date [new]: 2019-08-13 08:00:00\r\nduration [new]: 2\r\nduration_type [new]: 0\r\nhours_worked [new]: 0\r\nend_date [new]: 2019-08-15 08:00:00\r\nstatus [new]: 0\r\npercent_complete [new]: 0\r\ncreator [new]: 1\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\naccess [new]: 0\r\nnotify [new]: 0\r\ntype [new]: 0\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-14 23:55:47\r\nupdated [new]: 2019-08-14 23:55:47\r\n'),
 (81,'2019-08-15 00:03:43','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-14 23:38:32\r\nupdated [new]: 2019-08-15 00:03:43\r\n'),
 (82,'2019-08-15 00:04:11','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-15 00:03:43\r\nupdated [new]: 2019-08-15 00:04:11\r\n'),
 (83,'2019-08-15 00:04:43','::1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nupdated [old]: 2019-08-14 23:54:56\r\nupdated [new]: 2019-08-15 00:04:43\r\n'),
 (84,'2019-08-16 17:52:40','127.0.0.1','admin','users','login',''),
 (85,'2019-08-16 18:36:45','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nstart_date [old]: 2019-06-04 08:00:00\r\nstart_date [new]: 2019-06-05 08:00:00\r\nend_date [old]: 2019-06-06 08:00:00\r\nend_date [new]: 2019-06-06 00:00:00\r\nupdated [old]: 2019-08-15 00:04:11\r\nupdated [new]: 2019-08-16 18:36:45\r\n'),
 (86,'2019-08-16 18:40:12','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nstart_date [old]: 2019-06-05 08:00:00\r\nstart_date [new]: 2019-06-04 08:00:00\r\nend_date [old]: 2019-06-06 00:00:00\r\nend_date [new]: 2019-06-06 17:00:00\r\nupdated [old]: 2019-08-16 18:36:45\r\nupdated [new]: 2019-08-16 18:40:12\r\n'),
 (87,'2019-08-16 19:18:24','127.0.0.1','admin','users','login',''),
 (88,'2019-08-16 19:20:30','127.0.0.1','admin','users','login',''),
 (89,'2019-08-16 19:24:24','127.0.0.1','admin','users','login',''),
 (90,'2019-08-16 19:35:18','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nstart_date [old]: 2019-06-04 08:00:00\r\nstart_date [new]: 2019-06-07 08:00:00\r\nend_date [old]: 2019-06-06 17:00:00\r\nend_date [new]: 2019-06-11 17:00:00\r\nupdated [old]: 2019-08-16 18:40:12\r\nupdated [new]: 2019-08-16 19:34:19\r\n'),
 (91,'2019-08-16 19:36:13','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nduration [old]: 2\r\nduration [new]: 9\r\nduration_type [old]: 0\r\nduration_type [new]: 1\r\nend_date [old]: 2019-06-11 17:00:00\r\nend_date [new]: 2019-06-10 17:00:00\r\nupdated [old]: 2019-08-16 19:34:19\r\nupdated [new]: 2019-08-16 19:35:42\r\n'),
 (92,'2019-08-16 19:37:25','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-16 19:35:42\r\nupdated [new]: 2019-08-16 19:36:30\r\n'),
 (93,'2019-08-16 19:46:51','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nduration [old]: 9\r\nduration [new]: 15\r\nend_date [old]: 2019-06-10 17:00:00\r\nend_date [new]: 2019-06-11 17:00:00\r\nupdated [old]: 2019-08-16 19:36:30\r\nupdated [new]: 2019-08-16 19:37:40\r\n'),
 (94,'2019-08-16 19:47:56','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nduration [old]: 15\r\nduration [new]: 9\r\nupdated [old]: 2019-08-16 19:37:40\r\nupdated [new]: 2019-08-16 19:47:22\r\n'),
 (95,'2019-08-16 19:53:45','127.0.0.1','admin','config','edit','---Keys\r\nconfig_id : 4\r\n---Fields\r\nvalue [old]: yes\r\nvalue [new]: not\r\n'),
 (96,'2019-08-16 19:53:48','127.0.0.1','admin','users','logout',''),
 (97,'2019-08-16 19:53:56','127.0.0.1','admin','users','login',''),
 (98,'2019-08-16 19:56:46','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nend_date [old]: 2019-06-11 17:00:00\r\nend_date [new]: 2019-06-07 17:00:00\r\nupdated [old]: 2019-08-16 19:47:22\r\nupdated [new]: 2019-08-16 19:54:39\r\n'),
 (99,'2019-08-16 19:59:54','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nend_date [old]: 2019-06-07 17:00:00\r\nend_date [new]: 2019-06-09 17:00:00\r\nupdated [old]: 2019-08-16 19:54:39\r\nupdated [new]: 2019-08-16 19:59:19\r\n'),
 (100,'2019-08-16 20:02:37','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nduration [old]: 9\r\nduration [new]: 7\r\nend_date [old]: 2019-06-09 17:00:00\r\nend_date [new]: 2019-06-08 17:00:00\r\nupdated [old]: 2019-08-16 19:59:19\r\nupdated [new]: 2019-08-16 20:02:37\r\n'),
 (101,'2019-08-16 20:04:06','127.0.0.1','admin','users','logout',''),
 (102,'2019-08-16 20:04:13','127.0.0.1','admin','users','login',''),
 (103,'2019-08-16 20:34:51','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nend_date [old]: 2019-07-31 08:00:00\r\nend_date [new]: 2019-08-04 17:00:00\r\nupdated [old]: 2019-08-15 00:04:43\r\nupdated [new]: 2019-08-16 20:34:51\r\n'),
 (104,'2019-08-16 20:35:03','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 4\r\n---Fields\r\nend_date [old]: 2019-08-15 08:00:00\r\nend_date [new]: 2019-08-15 17:00:00\r\nupdated [old]: 2019-08-14 23:55:47\r\nupdated [new]: 2019-08-16 20:35:03\r\n'),
 (105,'2019-08-16 20:53:10','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nend_date [old]: 2019-06-08 17:00:00\r\nend_date [new]: 2019-06-07 17:00:00\r\nupdated [old]: 2019-08-16 20:02:37\r\nupdated [new]: 2019-08-16 20:53:09\r\n'),
 (106,'2019-08-16 20:53:19','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nstart_date [old]: 2019-06-07 08:00:00\r\nstart_date [new]: 2019-06-10 08:00:00\r\nend_date [old]: 2019-06-07 17:00:00\r\nend_date [new]: 2019-06-10 17:00:00\r\nupdated [old]: 2019-08-16 20:53:09\r\nupdated [new]: 2019-08-16 20:53:19\r\n'),
 (107,'2019-08-16 20:53:49','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nstart_date [old]: 2019-07-25 08:00:00\r\nstart_date [new]: 2019-07-24 08:00:00\r\nend_date [old]: 2019-08-04 17:00:00\r\nend_date [new]: 2019-08-02 17:00:00\r\nupdated [old]: 2019-08-16 20:34:51\r\nupdated [new]: 2019-08-16 20:53:49\r\n'),
 (108,'2019-08-16 20:54:13','127.0.0.1','admin','users','logout',''),
 (109,'2019-08-16 20:54:19','127.0.0.1','admin','users','login',''),
 (110,'2019-08-16 20:54:31','127.0.0.1','admin','config','edit','---Keys\r\nconfig_id : 4\r\n---Fields\r\nvalue [old]: not\r\nvalue [new]: yes\r\n'),
 (111,'2019-08-16 20:54:34','127.0.0.1','admin','users','logout',''),
 (112,'2019-08-16 20:54:40','127.0.0.1','admin','users','login',''),
 (113,'2019-08-16 20:54:55','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nstart_date [old]: 2019-06-10 08:00:00\r\nstart_date [new]: 2019-06-07 08:00:00\r\nend_date [old]: 2019-06-10 17:00:00\r\nend_date [new]: 2019-06-07 17:00:00\r\nupdated [old]: 2019-08-16 20:53:19\r\nupdated [new]: 2019-08-16 20:54:55\r\n'),
 (114,'2019-08-16 20:55:10','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nstart_date [old]: 2019-07-24 08:00:00\r\nstart_date [new]: 2019-07-23 08:00:00\r\nend_date [old]: 2019-08-02 17:00:00\r\nend_date [new]: 2019-08-05 17:00:00\r\nupdated [old]: 2019-08-16 20:53:49\r\nupdated [new]: 2019-08-16 20:55:10\r\n'),
 (115,'2019-08-16 20:55:35','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 4\r\n---Fields\r\nstart_date [old]: 2019-08-13 08:00:00\r\nstart_date [new]: 2019-08-14 08:00:00\r\nupdated [old]: 2019-08-16 20:35:03\r\nupdated [new]: 2019-08-16 20:55:35\r\n'),
 (116,'2019-08-16 21:23:24','127.0.0.1','admin','users','login',''),
 (117,'2019-08-16 21:27:59','127.0.0.1','admin','users','logout',''),
 (118,'2019-08-16 21:28:35','127.0.0.1','admin','users','login',''),
 (119,'2019-08-16 21:55:25','::1','admin','users','login',''),
 (120,'2019-08-16 22:01:22','::1','admin','users','login',''),
 (121,'2019-08-17 11:41:36','::1','admin','users','failed login',''),
 (122,'2019-08-17 11:41:42','::1','admin','users','login',''),
 (123,'2019-08-17 11:54:00','::1','admin','users','logout',''),
 (124,'2019-08-17 11:57:21','::1','admin','users','login',''),
 (125,'2019-08-17 12:07:02','::1','admin','tasks','edit','---Keys\r\ntask_id : 4\r\n---Fields\r\nduration [old]: 2\r\nduration [new]: 15\r\nend_date [old]: 2019-08-15 17:00:00\r\nend_date [new]: 2019-09-03 17:00:00\r\nupdated [old]: 2019-08-16 20:55:35\r\nupdated [new]: 2019-08-17 12:07:02\r\n'),
 (126,'2019-08-17 12:12:05','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nduration [old]: 7\r\nduration [new]: 9\r\nend_date [old]: 2019-06-07 17:00:00\r\nend_date [new]: 2019-06-10 17:00:00\r\nupdated [old]: 2019-08-16 20:54:55\r\nupdated [new]: 2019-08-17 12:12:05\r\n'),
 (127,'2019-08-17 12:14:08','::1','admin','users','logout',''),
 (128,'2019-08-17 12:14:23','::1','admin','users','login',''),
 (129,'2019-08-17 12:42:05','::1','admin','users','login',''),
 (130,'2019-08-17 13:08:02','::1','admin','users','login',''),
 (131,'2019-08-17 13:53:15','::1','admin','users','logout',''),
 (132,'2019-08-17 13:53:41','::1','admin','users','login',''),
 (133,'2019-08-17 13:55:17','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nname [old]: 2.- Tarea 2\r\nname [new]: 2.- Task 2\r\nupdated [old]: 2019-08-17 12:12:05\r\nupdated [new]: 2019-08-17 13:55:17\r\n'),
 (134,'2019-08-17 13:55:29','::1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nname [old]: 1.- Tarea 1\r\nname [new]: 1.- Task 1\r\nupdated [old]: 2019-08-16 20:55:10\r\nupdated [new]: 2019-08-17 13:55:29\r\n'),
 (135,'2019-08-17 13:55:42','::1','admin','tasks','edit','---Keys\r\ntask_id : 4\r\n---Fields\r\nname [old]: 1.1.- Tarea 1.1\r\nname [new]: 1.1.- Task 1.1\r\nupdated [old]: 2019-08-17 12:07:02\r\nupdated [new]: 2019-08-17 13:55:42\r\n'),
 (136,'2019-08-17 14:14:02','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\ndescription [old]: dedededede\r\ndescription [new]: dedededede \'prueba\'\r\nupdated [old]: 2019-08-17 13:55:17\r\nupdated [new]: 2019-08-17 14:14:02\r\n'),
 (137,'2019-08-17 14:14:33','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\ndescription [old]: dedededede \'prueba\'\r\ndescription [new]: dedededede\r\nupdated [old]: 2019-08-17 14:14:02\r\nupdated [new]: 2019-08-17 14:14:33\r\n'),
 (138,'2019-08-17 14:15:02','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nname [old]: 2.- Task 2\r\nname [new]: 2.- Task 2 \'prueba\'\r\nupdated [old]: 2019-08-17 14:14:33\r\nupdated [new]: 2019-08-17 14:15:02\r\n'),
 (139,'2019-08-17 14:15:24','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\ndescription [old]: dedededede\r\ndescription [new]: dedededede frfrf frfrfr frfr\r\nupdated [old]: 2019-08-17 14:15:02\r\nupdated [new]: 2019-08-17 14:15:24\r\n'),
 (140,'2019-08-17 15:13:39','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\ndescription [old]: dedededede frfrf frfrfr frfr\r\ndescription [new]: dedededede\r\nupdated [old]: 2019-08-17 14:15:24\r\nupdated [new]: 2019-08-17 15:13:39\r\n'),
 (141,'2019-08-17 15:19:46','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\ndescription [old]: dedededede\r\ndescription [new]: dedededede frfr frffrr\r\nupdated [old]: 2019-08-17 15:13:39\r\nupdated [new]: 2019-08-17 15:19:46\r\n'),
 (142,'2019-08-17 15:23:43','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\ndescription [old]: dedededede frfr frffrr\r\ndescription [new]: dedededede frfr frffreee tttttt\r\nupdated [old]: 2019-08-17 15:19:46\r\nupdated [new]: 2019-08-17 15:23:43\r\n'),
 (143,'2019-08-17 15:26:56','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\ndescription [old]: dedededede frfr frffreee tttttt\r\ndescription [new]: dedededede frfr \'prueba\' frffreee tttttt\r\nupdated [old]: 2019-08-17 15:23:43\r\nupdated [new]: 2019-08-17 15:26:56\r\n'),
 (144,'2019-08-17 15:27:24','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nname [old]: 2.- Task 2 \'prueba\'\r\nname [new]: 2.- Task 2\r\nupdated [old]: 2019-08-17 15:26:56\r\nupdated [new]: 2019-08-17 15:27:24\r\n'),
 (145,'2019-08-17 16:05:49','::1','admin','tasks','edit','---Keys\r\ntask_id : 4\r\n---Fields\r\nstart_date [old]: 2019-08-14 08:00:00\r\nstart_date [new]: 2019-07-24 08:00:00\r\nend_date [old]: 2019-09-03 17:00:00\r\nend_date [new]: 2019-08-13 17:00:00\r\nupdated [old]: 2019-08-17 13:55:42\r\nupdated [new]: 2019-08-17 16:05:49\r\n'),
 (146,'2019-08-17 16:07:15','::1','admin','tasks','add','---Keys\r\ntask_id : 5\r\n---Fields\r\nprojects_project_id [new]: 2\r\npercent_complete [new]: 0\r\nname [new]: 1.2.- Task 1.2\r\nmilestone [new]: 1\r\ndescription [new]: Prueba de ....\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-07-30 08:00:00\r\nduration [new]: 3\r\nduration_type [new]: 0\r\nend_date [new]: 2019-08-01 17:00:00\r\nhours_worked [new]: 0\r\nparent [new]: 1\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-17 16:05:59\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-17 16:05:59\r\n'),
 (147,'2019-08-17 16:08:30','::1','admin','tasks','edit','---Keys\r\ntask_id : 5\r\n---Fields\r\nmilestone [old]: 1\r\nmilestone [new]: 0\r\nupdated [old]: 2019-08-17 16:05:59\r\nupdated [new]: 2019-08-17 16:08:30\r\n'),
 (148,'2019-08-17 16:09:33','::1','admin','tasks','add','---Keys\r\ntask_id : 6\r\n---Fields\r\nprojects_project_id [new]: 2\r\npercent_complete [new]: 0\r\nname [new]: 3.- Task 3\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-05 08:00:00\r\nduration [new]: 5\r\nduration_type [new]: 0\r\nend_date [new]: 2019-08-09 17:00:00\r\nhours_worked [new]: 0\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-17 16:08:56\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-17 16:08:56\r\n'),
 (149,'2019-08-17 16:10:10','::1','admin','tasks','add','---Keys\r\ntask_id : 7\r\n---Fields\r\nprojects_project_id [new]: 2\r\npercent_complete [new]: 0\r\nname [new]: 3.1.- Task 3.1\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-12 08:00:00\r\nduration [new]: 10\r\nduration_type [new]: 0\r\nend_date [new]: 2019-08-23 17:00:00\r\nhours_worked [new]: 0\r\nparent [new]: 6\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-17 16:09:45\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-17 16:09:45\r\n'),
 (150,'2019-08-17 16:10:42','::1','admin','tasks','add','---Keys\r\ntask_id : 8\r\n---Fields\r\nprojects_project_id [new]: 2\r\npercent_complete [new]: 0\r\nname [new]: 3.2.- Task 3.2\r\nmilestone [new]: 0\r\ndescription [new]: frfrfrfr\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-28 08:00:00\r\nduration [new]: 3\r\nduration_type [new]: 0\r\nend_date [new]: 2019-08-30 17:00:00\r\nhours_worked [new]: 0\r\nparent [new]: 7\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-17 16:10:18\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-17 16:10:18\r\n'),
 (151,'2019-08-17 16:11:10','::1','admin','tasks','edit','---Keys\r\ntask_id : 8\r\n---Fields\r\nparent [old]: 7\r\nparent [new]: 6\r\nupdated [old]: 2019-08-17 16:10:18\r\nupdated [new]: 2019-08-17 16:11:10\r\n'),
 (152,'2019-08-17 17:06:39','::1','admin','tasks','edit','---Keys\r\ntask_id : 5\r\n---Fields\r\nstart_date [old]: 2019-07-30 08:00:00\r\nstart_date [new]: 2019-08-06 08:00:00\r\nend_date [old]: 2019-08-01 17:00:00\r\nend_date [new]: 2019-08-08 17:00:00\r\nupdated [old]: 2019-08-17 16:08:30\r\nupdated [new]: 2019-08-17 17:06:39\r\n'),
 (153,'2019-08-17 17:18:38','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nduration [old]: 9\r\nduration [new]: 10\r\nupdated [old]: 2019-08-17 15:27:24\r\nupdated [new]: 2019-08-17 17:18:38\r\n'),
 (154,'2019-08-17 17:18:55','::1','admin','tasks','edit','---Keys\r\ntask_id : 5\r\n---Fields\r\nduration [old]: 3\r\nduration [new]: 10\r\nend_date [old]: 2019-08-08 17:00:00\r\nend_date [new]: 2019-08-19 17:00:00\r\nupdated [old]: 2019-08-17 17:06:39\r\nupdated [new]: 2019-08-17 17:18:55\r\n'),
 (155,'2019-08-17 23:05:14','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nduration [old]: 10\r\nduration [new]: 12\r\nupdated [old]: 2019-08-17 17:18:38\r\nupdated [new]: 2019-08-17 23:05:14\r\n'),
 (156,'2019-08-17 23:15:12','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nduration [old]: 12\r\nduration [new]: 11\r\nupdated [old]: 2019-08-17 23:05:14\r\nupdated [new]: 2019-08-17 23:15:12\r\n'),
 (157,'2019-08-17 23:18:00','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-17 23:15:12\r\nupdated [new]: 2019-08-17 23:18:00\r\n'),
 (158,'2019-08-18 13:19:35','::1','admin','users','login',''),
 (159,'2019-08-18 13:31:51','::1','admin','users','login',''),
 (160,'2019-08-18 13:43:14','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-17 23:18:00\r\nupdated [new]: 2019-08-18 13:43:14\r\ndependent [old]: \r\ndependent [new]: 1\r\n'),
 (161,'2019-08-18 13:45:30','::1','admin','users','login',''),
 (162,'2019-08-18 13:45:58','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-18 13:43:14\r\nupdated [new]: 2019-08-18 13:45:58\r\ndependent [old]: 1\r\ndependent [new]: \r\n'),
 (163,'2019-08-18 13:46:09','::1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nupdated [old]: 2019-08-17 13:55:29\r\nupdated [new]: 2019-08-18 13:46:09\r\ndependent [old]: \r\ndependent [new]: 2\r\nend_date [old]: 2019-08-19 17:00:00\r\nend_date [new]: 2019-08-20 17:00:00\r\n'),
 (164,'2019-08-18 13:46:26','::1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nupdated [old]: 2019-08-18 13:46:09\r\nupdated [new]: 2019-08-18 13:46:26\r\ndependent [old]: 2\r\ndependent [new]: \r\nend_date [old]: 2019-08-19 17:00:00\r\nend_date [new]: 2019-08-20 17:00:00\r\n'),
 (165,'2019-08-18 13:46:35','::1','admin','tasks','edit','---Keys\r\ntask_id : 4\r\n---Fields\r\nupdated [old]: 2019-08-17 16:05:49\r\nupdated [new]: 2019-08-18 13:46:35\r\ndependent [old]: \r\ndependent [new]: 2\r\n'),
 (166,'2019-08-18 13:59:57','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-18 13:45:58\r\nupdated [new]: 2019-08-18 13:59:57\r\nduration [old]: 11\r\nduration [new]: 10\r\n'),
 (167,'2019-08-18 14:02:06','::1','admin','config','add','---Keys\r\nconfig_id : 7\r\n---Fields\r\nname [new]: update_dates_by_dependent\r\nvalue [new]: yes\r\ntype [new]: 0\r\n'),
 (168,'2019-08-18 14:03:27','::1','admin','users','logout',''),
 (169,'2019-08-18 14:03:36','::1','admin','users','login',''),
 (170,'2019-08-18 14:04:01','::1','admin','users','logout',''),
 (171,'2019-08-18 14:04:15','::1','admin','users','login',''),
 (172,'2019-08-18 14:09:12','::1','admin','users','logout',''),
 (173,'2019-08-18 14:09:31','::1','admin','users','login',''),
 (174,'2019-08-18 14:10:13','::1','admin','users','logout',''),
 (175,'2019-08-18 14:10:40','::1','admin','users','login',''),
 (176,'2019-08-18 14:12:01','::1','admin','users','logout',''),
 (177,'2019-08-18 14:12:13','::1','admin','users','login',''),
 (178,'2019-08-18 14:18:30','::1','admin','projects','add','---Keys\r\nproject_id : 3\r\n---Fields\r\ncompanies_company_id [new]: 3\r\ndepartments_dept_id [new]: 1\r\nname [new]: 2º Project\r\nshort_name [new]: P19/002\r\nowner [new]: 1\r\nstart_date [new]: 2019-08-13 08:00:00\r\nend_date [new]: 2019-09-25 15:00:00\r\nstatus [new]: 0\r\ncolor_identifier [new]: #0815A3\r\ndescription [new]: Pruebas del desarrollo y control de varios proyectos\r\ncreator [new]: 1\r\nprivate [new]: 0\r\nactive [new]: 0\r\nproject_parent [new]: 0\r\nproject_updator [new]: 1\r\ncreated [new]: 2019-08-18 14:16:24\r\nupdated [new]: 2019-08-18 14:16:24\r\nend_date_adjusted_user [new]: 1\r\n'),
 (179,'2019-08-18 14:19:27','::1','admin','tasks','add','---Keys\r\ntask_id : 9\r\n---Fields\r\nprojects_project_id [new]: 3\r\npercent_complete [new]: 0\r\nname [new]: 1.- Task 1\r\nmilestone [new]: 0\r\ndescription [new]: Pruebas\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-13 08:00:00\r\nduration [new]: 2\r\nduration_type [new]: 0\r\nend_date [new]: 2019-08-14 17:00:00\r\nhours_worked [new]: 0\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-18 14:18:38\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-18 14:18:38\r\n'),
 (180,'2019-08-18 16:08:19','::1','admin','projects','edit','---Keys\r\nproject_id : 2\r\n---Fields\r\nstart_date [old]: 2019-07-24 00:00:00\r\nstart_date [new]: 2019-07-24 08:00:00\r\nupdated [old]: 2019-08-14 20:43:57\r\nupdated [new]: 2019-08-18 16:08:19\r\n'),
 (181,'2019-08-18 16:09:32','::1','admin','projects','edit','---Keys\r\nproject_id : 3\r\n---Fields\r\nstart_date [old]: 2019-08-13 00:00:00\r\nstart_date [new]: 2019-08-13 08:00:00\r\nupdated [old]: 2019-08-18 14:16:24\r\nupdated [new]: 2019-08-18 16:09:32\r\n'),
 (182,'2019-08-18 16:10:42','::1','admin','users','logout',''),
 (183,'2019-08-18 16:10:51','::1','admin','users','login',''),
 (184,'2019-08-18 16:11:02','::1','admin','projects','edit','---Keys\r\nproject_id : 2\r\n---Fields\r\nstart_date [old]: 2019-07-24 00:00:00\r\nstart_date [new]: 2019-07-24 08:00:00\r\nupdated [old]: 2019-08-18 16:08:19\r\nupdated [new]: 2019-08-18 16:11:02\r\n'),
 (185,'2019-08-18 16:11:53','::1','admin','projects','edit','---Keys\r\nproject_id : 2\r\n---Fields\r\nstart_date [old]: 2019-07-24 00:00:00\r\nstart_date [new]: 2019-07-25 08:00:00\r\nupdated [old]: 2019-08-18 16:11:02\r\nupdated [new]: 2019-08-18 16:11:53\r\n'),
 (186,'2019-08-18 19:55:04','::1','admin','tasks','delete','---Keys\r\ntask_id : 9\r\n---Fields\r\nprojects_project_id [old]: 3\r\nname [old]: 1.- Task 1\r\nmilestone [old]: 0\r\nstart_date [old]: 2019-08-13 08:00:00\r\nduration [old]: 2\r\nduration_type [old]: 0\r\nnatural_days [old]: 2\r\nhours_worked [old]: 0\r\nend_date [old]: 2019-08-14 17:00:00\r\nstatus [old]: 0\r\npercent_complete [old]: 0\r\ndescription [old]: Pruebas\r\ncreator [old]: 1\r\norder [old]: 1\r\nlevel [old]: 1\r\ndynamic [old]: 0\r\naccess [old]: 0\r\nnotify [old]: 0\r\ntype [old]: 0\r\nupdator [old]: 1\r\ncreated [old]: 2019-08-18 14:18:38\r\nupdated [old]: 2019-08-18 14:18:38\r\n'),
 (187,'2019-08-18 20:00:16','::1','admin','tasks','add','---Keys\r\ntask_id : 10\r\n---Fields\r\nprojects_project_id [new]: 3\r\npercent_complete [new]: 0\r\nname [new]: 1.- Task\r\nmilestone [new]: 0\r\ndescription [new]: ewddede\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-19 08:00:00\r\nduration [new]: 4\r\nduration_type [new]: 0\r\nend_date [new]: 2019-08-22 17:00:00\r\nhours_worked [new]: 0\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-18 19:59:47\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-18 19:59:47\r\n'),
 (188,'2019-08-18 20:00:33','::1','admin','tasks','delete','---Keys\r\ntask_id : 10\r\n---Fields\r\nprojects_project_id [old]: 3\r\nname [old]: 1.- Task\r\nmilestone [old]: 0\r\nstart_date [old]: 2019-08-19 08:00:00\r\nduration [old]: 4\r\nduration_type [old]: 0\r\nnatural_days [old]: 4\r\nhours_worked [old]: 0\r\nend_date [old]: 2019-08-22 17:00:00\r\nstatus [old]: 0\r\npercent_complete [old]: 0\r\ndescription [old]: ewddede\r\ncreator [old]: 1\r\norder [old]: 1\r\nlevel [old]: 1\r\ndynamic [old]: 0\r\naccess [old]: 0\r\nnotify [old]: 0\r\ntype [old]: 0\r\nupdator [old]: 1\r\ncreated [old]: 2019-08-18 19:59:47\r\nupdated [old]: 2019-08-18 19:59:47\r\n'),
 (189,'2019-08-18 20:02:38','::1','admin','tasks','add','---Keys\r\ntask_id : 11\r\n---Fields\r\nprojects_project_id [new]: 3\r\npercent_complete [new]: 0\r\nname [new]: 1.- Task\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-19 08:00:00\r\nduration [new]: 3\r\nduration_type [new]: 0\r\nend_date [new]: 2019-08-21 17:00:00\r\nhours_worked [new]: 0\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-18 20:02:25\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-18 20:02:25\r\n'),
 (190,'2019-08-18 20:03:17','::1','admin','tasks','add','---Keys\r\ntask_id : 12\r\n---Fields\r\nprojects_project_id [new]: 3\r\npercent_complete [new]: 0\r\nname [new]: 2.- Task\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-21 08:00:00\r\nduration [new]: 10\r\nduration_type [new]: 0\r\nend_date [new]: 2019-09-03 17:00:00\r\nhours_worked [new]: 0\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-18 20:03:00\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-18 20:03:00\r\n'),
 (191,'2019-08-18 20:03:26','::1','admin','tasks','delete','---Keys\r\ntask_id : 12\r\n---Fields\r\nprojects_project_id [old]: 3\r\nname [old]: 2.- Task\r\nmilestone [old]: 0\r\nstart_date [old]: 2019-08-21 08:00:00\r\nduration [old]: 10\r\nduration_type [old]: 0\r\nnatural_days [old]: 14\r\nhours_worked [old]: 0\r\nend_date [old]: 2019-09-03 17:00:00\r\nstatus [old]: 0\r\npercent_complete [old]: 0\r\ncreator [old]: 1\r\norder [old]: 2\r\nlevel [old]: 1\r\ndynamic [old]: 0\r\naccess [old]: 0\r\nnotify [old]: 0\r\ntype [old]: 0\r\nupdator [old]: 1\r\ncreated [old]: 2019-08-18 20:03:00\r\nupdated [old]: 2019-08-18 20:03:00\r\n'),
 (192,'2019-08-18 20:09:01','::1','admin','tasks','add','---Keys\r\ntask_id : 13\r\n---Fields\r\nprojects_project_id [new]: 3\r\npercent_complete [new]: 0\r\nname [new]: 2.- Task\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-19 08:00:00\r\nduration [new]: 14\r\nduration_type [new]: 0\r\nend_date [new]: 2019-09-05 17:00:00\r\nhours_worked [new]: 0\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-18 20:08:46\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-18 20:08:46\r\n'),
 (193,'2019-08-18 20:09:12','::1','admin','tasks','delete','---Keys\r\ntask_id : 13\r\n---Fields\r\nprojects_project_id [old]: 3\r\nname [old]: 2.- Task\r\nmilestone [old]: 0\r\nstart_date [old]: 2019-08-19 08:00:00\r\nduration [old]: 14\r\nduration_type [old]: 0\r\nnatural_days [old]: 18\r\nhours_worked [old]: 0\r\nend_date [old]: 2019-09-05 17:00:00\r\nstatus [old]: 0\r\npercent_complete [old]: 0\r\ncreator [old]: 1\r\norder [old]: 2\r\nlevel [old]: 1\r\ndynamic [old]: 0\r\naccess [old]: 0\r\nnotify [old]: 0\r\ntype [old]: 0\r\nupdator [old]: 1\r\ncreated [old]: 2019-08-18 20:08:46\r\nupdated [old]: 2019-08-18 20:08:46\r\n'),
 (194,'2019-08-18 20:13:27','::1','admin','tasks','add','---Keys\r\ntask_id : 14\r\n---Fields\r\nprojects_project_id [new]: 3\r\npercent_complete [new]: 0\r\nname [new]: 2.- task\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-19 08:00:00\r\nduration [new]: 12\r\nduration_type [new]: 0\r\nend_date [new]: 2019-09-03 17:00:00\r\nhours_worked [new]: 0\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-18 20:13:16\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-18 20:13:16\r\n'),
 (195,'2019-08-18 20:13:40','::1','admin','tasks','delete','---Keys\r\ntask_id : 14\r\n---Fields\r\nprojects_project_id [old]: 3\r\nname [old]: 2.- task\r\nmilestone [old]: 0\r\nstart_date [old]: 2019-08-19 08:00:00\r\nduration [old]: 12\r\nduration_type [old]: 0\r\nnatural_days [old]: 16\r\nhours_worked [old]: 0\r\nend_date [old]: 2019-09-03 17:00:00\r\nstatus [old]: 0\r\npercent_complete [old]: 0\r\ncreator [old]: 1\r\norder [old]: 2\r\nlevel [old]: 1\r\ndynamic [old]: 0\r\naccess [old]: 0\r\nnotify [old]: 0\r\ntype [old]: 0\r\nupdator [old]: 1\r\ncreated [old]: 2019-08-18 20:13:16\r\nupdated [old]: 2019-08-18 20:13:16\r\n'),
 (196,'2019-08-18 20:15:07','::1','admin','tasks','add','---Keys\r\ntask_id : 15\r\n---Fields\r\nprojects_project_id [new]: 3\r\npercent_complete [new]: 0\r\nname [new]: task 2\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-19 08:00:00\r\nduration [new]: 1\r\nduration_type [new]: 0\r\nend_date [new]: 2019-08-19 17:00:00\r\nhours_worked [new]: 0\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-18 20:14:57\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-18 20:14:57\r\n'),
 (197,'2019-08-18 20:15:12','::1','admin','tasks','delete','---Keys\r\ntask_id : 15\r\n---Fields\r\nprojects_project_id [old]: 3\r\nname [old]: task 2\r\nmilestone [old]: 0\r\nstart_date [old]: 2019-08-19 08:00:00\r\nduration [old]: 1\r\nduration_type [old]: 0\r\nnatural_days [old]: 1\r\nhours_worked [old]: 0\r\nend_date [old]: 2019-08-19 17:00:00\r\nstatus [old]: 0\r\npercent_complete [old]: 0\r\ncreator [old]: 1\r\norder [old]: 2\r\nlevel [old]: 1\r\ndynamic [old]: 0\r\naccess [old]: 0\r\nnotify [old]: 0\r\ntype [old]: 0\r\nupdator [old]: 1\r\ncreated [old]: 2019-08-18 20:14:57\r\nupdated [old]: 2019-08-18 20:14:57\r\n'),
 (198,'2019-08-18 20:16:22','::1','admin','tasks','add','---Keys\r\ntask_id : 16\r\n---Fields\r\nprojects_project_id [new]: 3\r\npercent_complete [new]: 0\r\nname [new]: task 2\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-19 08:00:00\r\nduration [new]: 5\r\nduration_type [new]: 0\r\nend_date [new]: 2019-08-23 17:00:00\r\nhours_worked [new]: 0\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-18 20:16:13\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-18 20:16:13\r\n'),
 (199,'2019-08-18 20:16:36','::1','admin','tasks','delete','---Keys\r\ntask_id : 16\r\n---Fields\r\nprojects_project_id [old]: 3\r\nname [old]: task 2\r\nmilestone [old]: 0\r\nstart_date [old]: 2019-08-19 08:00:00\r\nduration [old]: 5\r\nduration_type [old]: 0\r\nnatural_days [old]: 5\r\nhours_worked [old]: 0\r\nend_date [old]: 2019-08-23 17:00:00\r\nstatus [old]: 0\r\npercent_complete [old]: 0\r\ncreator [old]: 1\r\norder [old]: 2\r\nlevel [old]: 1\r\ndynamic [old]: 0\r\naccess [old]: 0\r\nnotify [old]: 0\r\ntype [old]: 0\r\nupdator [old]: 1\r\ncreated [old]: 2019-08-18 20:16:13\r\nupdated [old]: 2019-08-18 20:16:13\r\n'),
 (200,'2019-08-18 20:19:24','::1','admin','users','login',''),
 (201,'2019-08-18 20:20:14','::1','admin','tasks','add','---Keys\r\ntask_id : 17\r\n---Fields\r\nprojects_project_id [new]: 3\r\nname [new]: task 2\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-19 08:00:00\r\nduration [new]: 3\r\nduration_type [new]: 0\r\nend_date [new]: 2019-08-21 17:00:00\r\nhours_worked [new]: 0\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-18 20:19:49\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-18 20:19:49\r\n'),
 (202,'2019-08-18 20:20:44','::1','admin','tasks','delete','---Keys\r\ntask_id : 17\r\n---Fields\r\nprojects_project_id [old]: 3\r\nname [old]: task 2\r\nmilestone [old]: 0\r\nstart_date [old]: 2019-08-19 08:00:00\r\nduration [old]: 3\r\nduration_type [old]: 0\r\nnatural_days [old]: 3\r\nhours_worked [old]: 0\r\nend_date [old]: 2019-08-21 17:00:00\r\nstatus [old]: 0\r\ncreator [old]: 1\r\norder [old]: 2\r\nlevel [old]: 1\r\ndynamic [old]: 0\r\naccess [old]: 0\r\nnotify [old]: 0\r\ntype [old]: 0\r\nupdator [old]: 1\r\ncreated [old]: 2019-08-18 20:19:49\r\nupdated [old]: 2019-08-18 20:19:49\r\n'),
 (203,'2019-08-18 20:29:48','::1','admin','tasks','add','---Keys\r\ntask_id : 18\r\n---Fields\r\nprojects_project_id [new]: 3\r\nname [new]: Task 2\r\nmilestone [new]: 0\r\ndescription [new]: sww\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-19 08:00:00\r\nduration [new]: 3\r\nduration_type [new]: 0\r\nend_date [new]: 2019-08-21 17:00:00\r\nhours_worked [new]: 0\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-18 20:29:26\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-18 20:29:26\r\n'),
 (204,'2019-08-18 20:38:26','::1','admin','tasks','edit','---Keys\r\ntask_id : 18\r\n---Fields\r\nupdated [old]: 2019-08-18 20:29:26\r\nupdated [new]: 2019-08-18 20:38:26\r\npercent_complete [old]: \r\npercent_complete [new]: 0\r\n'),
 (205,'2019-08-18 20:38:52','::1','admin','tasks','delete','---Keys\r\ntask_id : 18\r\n---Fields\r\nprojects_project_id [old]: 3\r\nname [old]: Task 2\r\nmilestone [old]: 0\r\nstart_date [old]: 2019-08-19 08:00:00\r\nduration [old]: 3\r\nduration_type [old]: 0\r\nnatural_days [old]: 3\r\nhours_worked [old]: 0\r\nend_date [old]: 2019-08-21 17:00:00\r\nstatus [old]: 0\r\npercent_complete [old]: 0\r\ndescription [old]: sww\r\ncreator [old]: 1\r\norder [old]: 2\r\nlevel [old]: 1\r\ndynamic [old]: 0\r\naccess [old]: 0\r\nnotify [old]: 0\r\ntype [old]: 0\r\nupdator [old]: 1\r\ncreated [old]: 2019-08-18 20:29:26\r\nupdated [old]: 2019-08-18 20:38:26\r\n'),
 (206,'2019-08-18 20:40:34','::1','admin','tasks','add','---Keys\r\ntask_id : 19\r\n---Fields\r\nprojects_project_id [new]: 3\r\npercent_complete [new]: 0\r\nname [new]: Task 2\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-19 08:00:00\r\nduration [new]: 3\r\nduration_type [new]: 0\r\nend_date [new]: 2019-08-21 17:00:00\r\nhours_worked [new]: 0\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-18 20:40:22\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-18 20:40:22\r\n'),
 (207,'2019-08-18 20:40:53','::1','admin','tasks','add','---Keys\r\ntask_id : 20\r\n---Fields\r\nprojects_project_id [new]: 3\r\npercent_complete [new]: 0\r\nname [new]: task 2.1\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-19 08:00:00\r\nduration [new]: 4\r\nduration_type [new]: 0\r\nend_date [new]: 2019-08-22 17:00:00\r\nhours_worked [new]: 0\r\nparent [new]: 19\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-18 20:40:39\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-18 20:40:39\r\n'),
 (208,'2019-08-18 20:41:25','::1','admin','tasks','add','---Keys\r\ntask_id : 21\r\n---Fields\r\nprojects_project_id [new]: 3\r\npercent_complete [new]: 0\r\nname [new]: Task 2.2\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-27 08:00:00\r\nduration [new]: 5\r\nduration_type [new]: 0\r\nend_date [new]: 2019-09-02 17:00:00\r\nhours_worked [new]: 0\r\nparent [new]: 19\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-18 20:41:03\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-18 20:41:03\r\n'),
 (209,'2019-08-18 20:41:40','::1','admin','tasks','delete','---Keys\r\ntask_id : 20\r\n---Fields\r\nprojects_project_id [old]: 3\r\nparent [old]: 19\r\nname [old]: task 2.1\r\nmilestone [old]: 0\r\nstart_date [old]: 2019-08-19 08:00:00\r\nduration [old]: 4\r\nduration_type [old]: 0\r\nnatural_days [old]: 4\r\nhours_worked [old]: 0\r\nend_date [old]: 2019-08-22 17:00:00\r\nstatus [old]: 0\r\npercent_complete [old]: 0\r\ncreator [old]: 1\r\norder [old]: 3\r\nlevel [old]: 2\r\ndynamic [old]: 0\r\naccess [old]: 0\r\nnotify [old]: 0\r\ntype [old]: 0\r\nupdator [old]: 1\r\ncreated [old]: 2019-08-18 20:40:39\r\nupdated [old]: 2019-08-18 20:40:39\r\n'),
 (210,'2019-08-18 20:42:45','::1','admin','tasks','edit','---Keys\r\ntask_id : 21\r\n---Fields\r\nupdated [old]: 2019-08-18 20:41:03\r\nupdated [new]: 2019-08-18 20:42:45\r\nend_date [old]: 2019-09-02 17:00:00\r\nend_date [new]: 2019-09-04 17:00:00\r\nduration [old]: 5\r\nduration [new]: 7\r\n'),
 (211,'2019-08-18 20:43:49','::1','admin','tasks','edit','---Keys\r\ntask_id : 21\r\n---Fields\r\nupdated [old]: 2019-08-18 20:42:45\r\nupdated [new]: 2019-08-18 20:43:49\r\nend_date [old]: 2019-09-04 17:00:00\r\nend_date [new]: 2019-08-29 17:00:00\r\nduration [old]: 7\r\nduration [new]: 3\r\n'),
 (212,'2019-08-18 20:44:14','::1','admin','tasks','delete','---Keys\r\ntask_id : 19\r\n---Fields\r\nprojects_project_id [old]: 3\r\nname [old]: Task 2\r\nmilestone [old]: 0\r\nstart_date [old]: 2019-08-27 08:00:00\r\nduration [old]: 3\r\nduration_type [old]: 0\r\nnatural_days [old]: 3\r\nhours_worked [old]: 0\r\nend_date [old]: 2019-08-29 17:00:00\r\nstatus [old]: 0\r\npercent_complete [old]: 0\r\ncreator [old]: 1\r\norder [old]: 2\r\nlevel [old]: 1\r\ndynamic [old]: 1\r\naccess [old]: 0\r\nnotify [old]: 0\r\ntype [old]: 0\r\nupdator [old]: 1\r\ncreated [old]: 2019-08-18 20:40:22\r\nupdated [old]: 2019-08-18 20:40:22\r\n'),
 (213,'2019-08-18 20:48:18','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-18 13:59:57\r\nupdated [new]: 2019-08-18 20:48:18\r\nend_date [old]: 2019-06-10 17:00:00\r\nend_date [new]: 2019-07-26 17:00:00\r\nstart_date [old]: 2019-06-07 08:00:00\r\nstart_date [new]: 2019-07-25 08:00:00\r\n'),
 (214,'2019-08-18 21:33:59','::1','admin','task_log','add','---Keys\r\ntask_log_id : 1\r\ncreator : 1\r\n---Fields\r\ntasks_task_id [new]: 1\r\nname [new]: Prueba\r\ndate_day [new]: 2019-08-18\r\npercent_complete [new]: 10\r\nhours [new]: 15\r\ntask_end_date [new]: 2019-08-19\r\nproblem [new]: 1\r\ncreated [new]: 2019-08-18 21:33:28\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-18 21:33:28\r\n'),
 (215,'2019-08-18 21:40:17','::1','admin','users','login',''),
 (216,'2019-08-18 21:40:30','::1','admin','task_log','edit','---Keys\r\ntask_log_id : 1\r\n---Fields\r\nupdated [old]: 2019-08-18 21:33:28\r\nupdated [new]: 2019-08-18 21:40:30\r\nproblem [old]: 1\r\nproblem [new]: 0\r\n'),
 (217,'2019-08-18 22:59:19','::1','admin','users','logout',''),
 (218,'2019-08-18 22:59:27','::1','admin','users','login',''),
 (219,'2019-08-18 23:18:23','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-18 20:48:18\r\nupdated [new]: 2019-08-18 23:18:23\r\nduration [old]: 10\r\nduration [new]: 15\r\n'),
 (220,'2019-08-18 23:23:02','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-18 23:18:23\r\nupdated [new]: 2019-08-18 23:23:02\r\nduration [old]: 15\r\nduration [new]: 10\r\n'),
 (221,'2019-08-18 23:25:07','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-18 23:23:02\r\nupdated [new]: 2019-08-18 23:25:07\r\nduration [old]: 10\r\nduration [new]: 11\r\n'),
 (222,'2019-08-18 23:25:50','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-18 23:25:07\r\nupdated [new]: 2019-08-18 23:25:50\r\n'),
 (223,'2019-08-18 23:26:22','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-18 23:25:50\r\nupdated [new]: 2019-08-18 23:26:22\r\n'),
 (224,'2019-08-18 23:27:12','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-18 23:26:22\r\nupdated [new]: 2019-08-18 23:27:12\r\n'),
 (225,'2019-08-18 23:30:02','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-18 23:27:12\r\nupdated [new]: 2019-08-18 23:30:01\r\nend_date [old]: 2019-07-26 17:00:00\r\nend_date [new]: 2019-09-03 17:00:00\r\nduration [old]: 11\r\nduration [new]: 2\r\nstart_date [old]: 2019-07-25 08:00:00\r\nstart_date [new]: 2019-09-03 08:00:00\r\n'),
 (226,'2019-08-18 23:45:18','::1','admin','users','logout',''),
 (227,'2019-08-19 12:57:40','::1','admin','users','login',''),
 (228,'2019-08-19 12:58:43','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 1\r\n---Fields\r\nname [old]: Prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-18 21:33:28\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-18 21:40:30\r\nhours [old]: 15\r\ndate_day [old]: 2019-08-18\r\npercent_complete [old]: 10\r\ntask_end_date [old]: 2019-08-19 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 1\r\n'),
 (229,'2019-08-19 13:01:59','::1','admin','task_log','add','---Keys\r\ntask_log_id : 2\r\n---Fields\r\nupdated [new]: 2019-08-19 13:01:43\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 13:01:43\r\ndate_day [new]: 2019-08-19\r\nname [new]: Avance correcto\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-08-13\r\npercent_complete [new]: 35\r\ntasks_task_id [new]: 4\r\n'),
 (230,'2019-08-19 13:19:28','::1','admin','users','login',''),
 (231,'2019-08-19 14:06:24','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nduration [old]: 2\r\nduration [new]: 5\r\nupdated [old]: 2019-08-18 23:30:01\r\nupdated [new]: 2019-08-19 14:06:24\r\n'),
 (232,'2019-08-19 14:06:40','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nduration [old]: 5\r\nduration [new]: 15\r\nend_date [old]: 2019-09-03 17:00:00\r\nend_date [new]: 2019-09-04 17:00:00\r\nupdated [old]: 2019-08-19 14:06:24\r\nupdated [new]: 2019-08-19 14:06:39\r\n'),
 (233,'2019-08-19 14:07:17','::1','admin','task_log','add','---Keys\r\ntask_log_id : 3\r\n---Fields\r\nupdated [new]: 2019-08-19 14:07:01\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 14:07:01\r\ndate_day [new]: 2019-08-19\r\nname [new]: Prueba\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 35\r\nhours [new]: 15\r\ntasks_task_id [new]: 2\r\n'),
 (234,'2019-08-19 14:10:42','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 3\r\n---Fields\r\nname [old]: Prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 14:07:01\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 14:07:01\r\nhours [old]: 15\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 35\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\nprojects_project_id [old]: 0\r\n'),
 (235,'2019-08-19 14:10:58','::1','admin','task_log','add','---Keys\r\ntask_log_id : 4\r\n---Fields\r\nupdated [new]: 2019-08-19 14:10:46\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 14:10:46\r\ndate_day [new]: 2019-08-19\r\nname [new]: prueba\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 40\r\nhours [new]: 20\r\ntasks_task_id [new]: 2\r\n'),
 (236,'2019-08-19 14:11:11','::1','admin','task_log','add','---Keys\r\ntask_log_id : 5\r\n---Fields\r\nupdated [new]: 2019-08-19 14:10:46\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 14:10:46\r\ndate_day [new]: 2019-08-19\r\nname [new]: prueba\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 40\r\nhours [new]: 20\r\ntasks_task_id [new]: 2\r\n'),
 (237,'2019-08-19 14:13:20','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 4\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 14:10:46\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 14:10:46\r\nhours [old]: 20\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 40\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\nprojects_project_id [old]: 0\r\n'),
 (238,'2019-08-19 14:13:20','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 5\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 14:10:46\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 14:10:46\r\nhours [old]: 20\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 40\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\nprojects_project_id [old]: 0\r\n'),
 (239,'2019-08-19 14:13:41','::1','admin','task_log','add','---Keys\r\ntask_log_id : 6\r\n---Fields\r\nupdated [new]: 2019-08-19 14:13:22\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 14:13:22\r\ndate_day [new]: 2019-08-19\r\nname [new]: prueba\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 45\r\nhours [new]: 12\r\ntasks_task_id [new]: 2\r\n'),
 (240,'2019-08-19 14:15:59','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 6\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 14:13:22\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 14:13:22\r\nhours [old]: 12\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 45\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\nprojects_project_id [old]: 0\r\n'),
 (241,'2019-08-19 14:16:14','::1','admin','task_log','add','---Keys\r\ntask_log_id : 7\r\n---Fields\r\nupdated [new]: 2019-08-19 14:16:01\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 14:16:01\r\ndate_day [new]: 2019-08-19\r\nname [new]: prueba\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 50\r\nhours [new]: 19\r\ntasks_task_id [new]: 2\r\n'),
 (242,'2019-08-19 14:16:56','::1','admin','task_log','add','---Keys\r\ntask_log_id : 8\r\n---Fields\r\nupdated [new]: 2019-08-19 14:16:42\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 14:16:42\r\ndate_day [new]: 2019-08-19\r\nname [new]: prueba\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 55\r\nhours [new]: 14\r\ntasks_task_id [new]: 2\r\n'),
 (243,'2019-08-19 14:18:32','::1','admin','users','login',''),
 (244,'2019-08-19 14:18:56','::1','admin','task_log','add','---Keys\r\ntask_log_id : 9\r\n---Fields\r\nupdated [new]: 2019-08-19 14:18:46\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 14:18:46\r\ndate_day [new]: 2019-08-19\r\nname [new]: prueba\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 55\r\nhours [new]: 5\r\ntasks_task_id [new]: 2\r\n'),
 (245,'2019-08-19 14:27:14','::1','admin','task_log','add','---Keys\r\ntask_log_id : 10\r\n---Fields\r\nupdated [new]: 2019-08-19 14:26:53\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 14:26:53\r\ndate_day [new]: 2019-08-19\r\nname [new]: prueba\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 55\r\ntasks_task_id [new]: 2\r\n'),
 (246,'2019-08-19 14:28:27','::1','admin','task_log','add','---Keys\r\ntask_log_id : 11\r\n---Fields\r\nupdated [new]: 2019-08-19 14:28:12\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 14:28:12\r\ndate_day [new]: 2019-08-19\r\nname [new]: prueba\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 55\r\nhours [new]: 3\r\ntasks_task_id [new]: 2\r\n'),
 (247,'2019-08-19 14:29:31','::1','admin','task_log','add','---Keys\r\ntask_log_id : 12\r\n---Fields\r\nupdated [new]: 2019-08-19 14:29:21\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 14:29:21\r\ndate_day [new]: 2019-08-19\r\nname [new]: prueba\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 55\r\nhours [new]: 4\r\ntasks_task_id [new]: 2\r\n'),
 (248,'2019-08-19 14:34:04','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 12\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 14:29:21\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 14:29:21\r\nhours [old]: 4\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 55\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (249,'2019-08-19 14:34:04','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 7\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 14:16:01\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 14:16:01\r\nhours [old]: 19\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 50\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (250,'2019-08-19 14:34:04','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 8\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 14:16:42\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 14:16:42\r\nhours [old]: 14\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 55\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (251,'2019-08-19 14:34:04','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 9\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 14:18:46\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 14:18:46\r\nhours [old]: 5\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 55\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (252,'2019-08-19 14:34:04','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 10\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 14:26:53\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 14:26:53\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 55\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (253,'2019-08-19 14:34:04','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 11\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 14:28:12\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 14:28:12\r\nhours [old]: 3\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 55\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (254,'2019-08-19 14:34:21','::1','admin','task_log','add','---Keys\r\ntask_log_id : 13\r\n---Fields\r\nupdated [new]: 2019-08-19 14:34:09\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 14:34:09\r\ndate_day [new]: 2019-08-19\r\nname [new]: prueba\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 55\r\nhours [new]: 15\r\ntasks_task_id [new]: 2\r\n'),
 (255,'2019-08-19 14:34:45','::1','admin','task_log','add','---Keys\r\ntask_log_id : 14\r\n---Fields\r\nupdated [new]: 2019-08-19 14:34:38\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 14:34:38\r\ndate_day [new]: 2019-08-19\r\nname [new]: frfrfr\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 55\r\nhours [new]: 10\r\ntasks_task_id [new]: 2\r\n');
INSERT INTO `project_audit` (`id`,`datetime`,`ip`,`user`,`table`,`action`,`description`) VALUES 
 (256,'2019-08-19 14:35:33','::1','admin','task_log','add','---Keys\r\ntask_log_id : 15\r\n---Fields\r\nupdated [new]: 2019-08-19 14:35:25\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 14:35:25\r\ndate_day [new]: 2019-08-19\r\nname [new]: rerer\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 55\r\nhours [new]: 14\r\ntasks_task_id [new]: 2\r\n'),
 (257,'2019-08-19 14:35:45','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 13\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 14:34:09\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 14:34:09\r\nhours [old]: 15\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 55\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (258,'2019-08-19 14:35:45','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 14\r\n---Fields\r\nname [old]: frfrfr\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 14:34:38\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 14:34:38\r\nhours [old]: 10\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 55\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (259,'2019-08-19 14:35:45','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 15\r\n---Fields\r\nname [old]: rerer\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 14:35:25\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 14:35:25\r\nhours [old]: 14\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 55\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (260,'2019-08-19 14:36:07','::1','admin','task_log','add','---Keys\r\ntask_log_id : 16\r\n---Fields\r\nupdated [new]: 2019-08-19 14:35:57\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 14:35:57\r\ndate_day [new]: 2019-08-19\r\nname [new]: frfrf\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 60\r\nhours [new]: 21\r\ntasks_task_id [new]: 2\r\n'),
 (261,'2019-08-19 15:22:19','::1','admin','task_log','add','---Keys\r\ntask_log_id : 17\r\n---Fields\r\nupdated [new]: 2019-08-19 15:22:00\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 15:22:00\r\ndate_day [new]: 2019-08-19\r\nname [new]: dede\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 60\r\nhours [new]: 9\r\ntasks_task_id [new]: 2\r\n'),
 (262,'2019-08-19 15:23:28','::1','admin','task_log','add','---Keys\r\ntask_log_id : 18\r\n---Fields\r\nupdated [new]: 2019-08-19 15:22:49\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 15:22:49\r\ndate_day [new]: 2019-08-19\r\nname [new]: cierre\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-08-21\r\npercent_complete [new]: 100\r\nhours [new]: 5\r\ntasks_task_id [new]: 2\r\n'),
 (263,'2019-08-19 15:25:48','::1','admin','task_log','add','---Keys\r\ntask_log_id : 19\r\n---Fields\r\nupdated [new]: 2019-08-19 15:25:32\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 15:25:32\r\ndate_day [new]: 2019-08-19\r\nname [new]: rerere\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-01\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (264,'2019-08-19 15:27:09','::1','admin','users','login',''),
 (265,'2019-08-19 15:27:45','::1','admin','task_log','add','---Keys\r\ntask_log_id : 20\r\n---Fields\r\nupdated [new]: 2019-08-19 15:27:36\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 15:27:36\r\ndate_day [new]: 2019-08-19\r\nname [new]: dededede\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-02\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (266,'2019-08-19 15:29:28','::1','admin','task_log','add','---Keys\r\ntask_log_id : 21\r\n---Fields\r\nupdated [new]: 2019-08-19 15:29:13\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 15:29:13\r\ndate_day [new]: 2019-08-19\r\nname [new]: ssss\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-02\r\npercent_complete [new]: 100\r\nhours [new]: 1\r\ntasks_task_id [new]: 2\r\n'),
 (267,'2019-08-19 15:31:22','::1','admin','task_log','add','---Keys\r\ntask_log_id : 22\r\n---Fields\r\nupdated [new]: 2019-08-19 15:31:05\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 15:31:05\r\ndate_day [new]: 2019-08-19\r\nname [new]: ssss\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-08-15\r\npercent_complete [new]: 100\r\nhours [new]: 3\r\ntasks_task_id [new]: 2\r\n'),
 (268,'2019-08-19 15:32:49','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 16\r\n---Fields\r\nname [old]: frfrf\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 14:35:57\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 14:35:57\r\nhours [old]: 21\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 60\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (269,'2019-08-19 15:32:49','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 17\r\n---Fields\r\nname [old]: dede\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 15:22:00\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 15:22:00\r\nhours [old]: 9\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 60\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (270,'2019-08-19 15:32:49','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 18\r\n---Fields\r\nname [old]: cierre\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 15:22:49\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 15:22:49\r\nhours [old]: 5\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-08-21 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (271,'2019-08-19 15:32:49','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 19\r\n---Fields\r\nname [old]: rerere\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 15:25:32\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 15:25:32\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-01 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (272,'2019-08-19 15:32:49','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 20\r\n---Fields\r\nname [old]: dededede\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 15:27:36\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 15:27:36\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-02 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (273,'2019-08-19 15:32:49','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 21\r\n---Fields\r\nname [old]: ssss\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 15:29:13\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 15:29:13\r\nhours [old]: 1\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-02 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (274,'2019-08-19 15:32:49','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 22\r\n---Fields\r\nname [old]: ssss\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 15:31:05\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 15:31:05\r\nhours [old]: 3\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-08-15 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (275,'2019-08-19 15:33:05','::1','admin','task_log','add','---Keys\r\ntask_log_id : 23\r\n---Fields\r\nupdated [new]: 2019-08-19 15:32:52\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 15:32:52\r\ndate_day [new]: 2019-08-19\r\nname [new]: cierre\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-02\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (276,'2019-08-19 15:34:43','::1','admin','task_log','add','---Keys\r\ntask_log_id : 24\r\n---Fields\r\nupdated [new]: 2019-08-19 15:34:14\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 15:34:14\r\ndate_day [new]: 2019-08-19\r\nname [new]: Cierre\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-08-22\r\npercent_complete [new]: 100\r\nhours [new]: 20\r\ntasks_task_id [new]: 5\r\n'),
 (277,'2019-08-19 15:40:56','::1','admin','task_log','add','---Keys\r\ntask_log_id : 25\r\n---Fields\r\nupdated [new]: 2019-08-19 15:40:44\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 15:40:44\r\ndate_day [new]: 2019-08-19\r\nname [new]: prueba\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-01\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (278,'2019-08-19 15:43:18','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 23\r\n---Fields\r\nname [old]: cierre\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 15:32:52\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 15:32:52\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-02 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (279,'2019-08-19 15:43:18','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 25\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 15:40:44\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 15:40:44\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-01 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (280,'2019-08-19 15:43:35','::1','admin','task_log','add','---Keys\r\ntask_log_id : 26\r\n---Fields\r\nupdated [new]: 2019-08-19 15:43:20\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 15:43:20\r\ndate_day [new]: 2019-08-19\r\nname [new]: prueba\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-10\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (281,'2019-08-19 15:43:58','::1','admin','task_log','add','---Keys\r\ntask_log_id : 27\r\n---Fields\r\nupdated [new]: 2019-08-19 15:43:48\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 15:43:48\r\ndate_day [new]: 2019-08-19\r\nname [new]: dede\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-12\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (282,'2019-08-19 15:45:02','::1','admin','task_log','add','---Keys\r\ntask_log_id : 28\r\n---Fields\r\nupdated [new]: 2019-08-19 15:44:52\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 15:44:52\r\ndate_day [new]: 2019-08-19\r\nname [new]: dedede\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-15\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (283,'2019-08-19 15:50:03','::1','admin','task_log','add','---Keys\r\ntask_log_id : 29\r\n---Fields\r\nupdated [new]: 2019-08-19 15:49:52\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 15:49:52\r\ndate_day [new]: 2019-08-19\r\nname [new]: dede\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-13\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (284,'2019-08-19 15:50:50','::1','admin','task_log','add','---Keys\r\ntask_log_id : 30\r\n---Fields\r\nupdated [new]: 2019-08-19 15:50:43\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 15:50:43\r\ndate_day [new]: 2019-08-19\r\nname [new]: dedede\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-10\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (285,'2019-08-19 15:58:27','::1','admin','users','logout',''),
 (286,'2019-08-19 15:58:35','::1','humanes','users','login',''),
 (287,'2019-08-19 16:09:35','::1','humanes','users','logout',''),
 (288,'2019-08-19 16:13:10','::1','humanes','users','login',''),
 (289,'2019-08-19 16:14:27','::1','humanes','users','logout',''),
 (290,'2019-08-19 16:16:04','::1','admin','users','login',''),
 (291,'2019-08-19 17:00:36','::1','admin','users','logout',''),
 (292,'2019-08-19 17:01:56','::1','admin','users','login',''),
 (293,'2019-08-19 17:03:10','::1','admin','tasks','edit','---Keys\r\ntask_id : 11\r\n---Fields\r\nduration [old]: 3\r\nduration [new]: 5\r\nend_date [old]: 2019-08-21 17:00:00\r\nend_date [new]: 2019-08-23 17:00:00\r\nupdated [old]: 2019-08-18 20:02:25\r\nupdated [new]: 2019-08-19 17:03:10\r\n'),
 (294,'2019-08-19 17:44:20','::1','admin','users','logout',''),
 (295,'2019-08-19 17:44:27','::1','admin','users','login',''),
 (296,'2019-08-19 18:31:02','::1','admin','users','login',''),
 (297,'2019-08-19 18:37:14','::1','admin','files','delete','---Keys\r\nfile_id : 2\r\n---Fields\r\nprojects_project_id [old]: 2\r\ntasks_task_id [old]: 1\r\ndescription [old]: Prueba\r\nfiles_content [old]: [{\"name\":\"files\\/fhumanes2_i3q9jypy.png\",\"usrName\":\"fhumanes2.png\",\"size\":80426,\"type\":\"image\\/png\",\"searchStr\":\"fhumanes2.png,!:sStrEnd\"}]\r\n'),
 (298,'2019-08-19 18:38:44','::1','admin','users','logout',''),
 (299,'2019-08-19 18:45:16','::1','admin','users','login',''),
 (300,'2019-08-19 19:00:14','::1','admin','task_log','add','---Keys\r\ntask_log_id : 31\r\n---Fields\r\nupdated [new]: 2019-08-19 18:59:59\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 18:59:59\r\ndate_day [new]: 2019-08-19\r\nname [new]: frfrfr\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-11\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (301,'2019-08-19 19:26:42','::1','admin','task_log','add','---Keys\r\ntask_log_id : 32\r\n---Fields\r\nupdated [new]: 2019-08-19 19:26:10\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 19:26:10\r\ndate_day [new]: 2019-08-19\r\nname [new]: rfrfr\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-01\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (302,'2019-08-19 19:27:00','::1','admin','task_log','add','---Keys\r\ntask_log_id : 33\r\n---Fields\r\nupdated [new]: 2019-08-19 19:26:52\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 19:26:52\r\ndate_day [new]: 2019-08-19\r\nname [new]: frfrfr\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-01\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (303,'2019-08-19 19:28:20','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nduration [old]: 15\r\nduration [new]: 12\r\nupdated [old]: 2019-08-19 14:06:39\r\nupdated [new]: 2019-08-19 19:28:20\r\n'),
 (304,'2019-08-19 19:28:59','::1','admin','tasks','edit','---Keys\r\ntask_id : 4\r\n---Fields\r\nstart_date [old]: 2019-09-11 00:00:00\r\nstart_date [new]: 2019-08-01 08:00:00\r\nend_date [old]: 2019-08-13 17:00:00\r\nend_date [new]: 2019-08-21 17:00:00\r\nupdated [old]: 2019-08-18 13:46:35\r\nupdated [new]: 2019-08-19 19:28:59\r\n'),
 (305,'2019-08-19 19:30:52','::1','admin','task_log','add','---Keys\r\ntask_log_id : 34\r\n---Fields\r\nupdated [new]: 2019-08-19 19:30:44\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 19:30:44\r\ndate_day [new]: 2019-08-19\r\nname [new]: deede\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-08-21\r\npercent_complete [new]: 35\r\ntasks_task_id [new]: 4\r\n'),
 (306,'2019-08-19 19:32:11','::1','admin','task_log','add','---Keys\r\ntask_log_id : 35\r\n---Fields\r\nupdated [new]: 2019-08-19 19:32:03\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 19:32:03\r\ndate_day [new]: 2019-08-19\r\nname [new]: dddd\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-08-21\r\npercent_complete [new]: 40\r\ntasks_task_id [new]: 4\r\n'),
 (307,'2019-08-19 19:32:42','::1','admin','task_log','add','---Keys\r\ntask_log_id : 36\r\n---Fields\r\nupdated [new]: 2019-08-19 19:32:27\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 19:32:27\r\ndate_day [new]: 2019-08-19\r\nname [new]: ddd\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-01\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (308,'2019-08-19 19:35:21','::1','admin','task_log','add','---Keys\r\ntask_log_id : 37\r\n---Fields\r\nupdated [new]: 2019-08-19 19:35:09\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 19:35:09\r\ndate_day [new]: 2019-08-19\r\nname [new]: ssssss\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-01\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (309,'2019-08-19 19:39:20','::1','admin','users','login',''),
 (310,'2019-08-19 19:39:51','::1','admin','task_log','add','---Keys\r\ntask_log_id : 38\r\n---Fields\r\nupdated [new]: 2019-08-19 19:39:34\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 19:39:34\r\ndate_day [new]: 2019-08-19\r\nname [new]: deddedee\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-08-24\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (311,'2019-08-19 19:43:03','::1','admin','task_log','add','---Keys\r\ntask_log_id : 39\r\n---Fields\r\nupdated [new]: 2019-08-19 19:42:56\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 19:42:56\r\ndate_day [new]: 2019-08-19\r\nname [new]: dededede\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (312,'2019-08-19 19:45:01','::1','admin','task_log','add','---Keys\r\ntask_log_id : 40\r\n---Fields\r\nupdated [new]: 2019-08-19 19:44:54\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 19:44:54\r\ndate_day [new]: 2019-08-19\r\nname [new]: ffrr\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (313,'2019-08-19 19:47:55','::1','admin','task_log','add','---Keys\r\ntask_log_id : 41\r\n---Fields\r\nupdated [new]: 2019-08-19 19:47:50\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 19:47:50\r\ndate_day [new]: 2019-08-19\r\nname [new]: sssss\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-09-04\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (314,'2019-08-19 19:51:10','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 26\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 15:43:20\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 15:43:20\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-10 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (315,'2019-08-19 19:51:10','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 27\r\n---Fields\r\nname [old]: dede\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 15:43:48\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 15:43:48\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-12 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (316,'2019-08-19 19:51:10','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 28\r\n---Fields\r\nname [old]: dedede\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 15:44:52\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 15:44:52\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-15 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (317,'2019-08-19 19:51:10','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 29\r\n---Fields\r\nname [old]: dede\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 15:49:52\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 15:49:52\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-13 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (318,'2019-08-19 19:51:10','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 30\r\n---Fields\r\nname [old]: dedede\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 15:50:43\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 15:50:43\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-10 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (319,'2019-08-19 19:51:10','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 31\r\n---Fields\r\nname [old]: frfrfr\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 18:59:59\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 18:59:59\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-11 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (320,'2019-08-19 19:51:10','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 32\r\n---Fields\r\nname [old]: rfrfr\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 19:26:10\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 19:26:10\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-01 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (321,'2019-08-19 19:51:10','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 33\r\n---Fields\r\nname [old]: frfrfr\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 19:26:52\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 19:26:52\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-01 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (322,'2019-08-19 19:51:10','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 36\r\n---Fields\r\nname [old]: ddd\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 19:32:27\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 19:32:27\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-01 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (323,'2019-08-19 19:51:10','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 37\r\n---Fields\r\nname [old]: ssssss\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 19:35:09\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 19:35:09\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-01 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (324,'2019-08-19 19:51:10','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 38\r\n---Fields\r\nname [old]: deddedee\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 19:39:34\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 19:39:34\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-08-24 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (325,'2019-08-19 19:51:10','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 39\r\n---Fields\r\nname [old]: dededede\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 19:42:56\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 19:42:56\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (326,'2019-08-19 19:51:10','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 40\r\n---Fields\r\nname [old]: ffrr\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 19:44:54\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 19:44:54\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (327,'2019-08-19 20:14:16','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-19 19:28:20\r\nupdated [new]: 2019-08-19 20:14:16\r\nend_date [old]: 2019-09-04 17:00:00\r\nend_date [new]: 2019-08-09 17:00:00\r\nstart_date [old]: 2019-09-03 08:00:00\r\nstart_date [new]: 2019-08-08 08:00:00\r\n'),
 (328,'2019-08-19 20:15:39','::1','admin','task_log','add','---Keys\r\ntask_log_id : 42\r\n---Fields\r\nupdated [new]: 2019-08-19 20:15:31\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 20:15:31\r\ndate_day [new]: 2019-08-19\r\nname [new]: dddd\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-08-09\r\npercent_complete [new]: 85\r\ntasks_task_id [new]: 2\r\n'),
 (329,'2019-08-19 20:17:33','::1','admin','task_log','add','---Keys\r\ntask_log_id : 43\r\n---Fields\r\nupdated [new]: 2019-08-19 20:17:19\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 20:17:19\r\ndate_day [new]: 2019-08-19\r\nname [new]: dede\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-08-12\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (330,'2019-08-19 20:22:29','::1','admin','task_log','add','---Keys\r\ntask_log_id : 44\r\n---Fields\r\nupdated [new]: 2019-08-19 20:22:17\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 20:22:17\r\ndate_day [new]: 2019-08-19\r\nname [new]: ssss\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-08-09\r\npercent_complete [new]: 80\r\ntasks_task_id [new]: 2\r\n'),
 (331,'2019-08-19 20:33:21','::1','admin','task_log','add','---Keys\r\ntask_log_id : 45\r\n---Fields\r\nupdated [new]: 2019-08-19 20:33:07\r\nupdator [new]: 1\r\ncreated [new]: 2019-08-19 20:33:07\r\ndate_day [new]: 2019-08-19\r\nname [new]: gtgtgt\r\ncreator [new]: 1\r\ntask_end_date [new]: 2019-08-13\r\npercent_complete [new]: 100\r\ntasks_task_id [new]: 2\r\n'),
 (332,'2019-08-19 20:45:52','::1','admin','users','logout',''),
 (333,'2019-08-20 12:52:59','::1','admin','users','login',''),
 (334,'2019-08-20 13:24:55','::1','admin','users','logout',''),
 (335,'2019-08-20 13:25:06','::1','admin','users','login',''),
 (336,'2019-08-20 13:54:21','::1','admin','users','edit','---Keys\r\nuser_id : 4\r\n---Fields\r\nlogin [old]: humanes\r\nlogin [new]: user1\r\nusername [old]: Fernando Humanes\r\nusername [new]: Usuario 1\r\npassword [old]: 1e63dafa7e63f073ed2f362a49f8cf24\r\npassword [new]: ee11cbb19052e40b07aac0ca060c23ee\r\nemail [old]: info@fhumanes.com\r\nemail [new]: user1@fhumanes.com\r\n'),
 (337,'2019-08-20 13:55:35','::1','admin','companies','add','---Keys\r\ncompany_id : 4\r\n---Fields\r\nname [new]: Company 2\r\nprivate [new]: 0\r\nowner [new]: 1\r\ntype [new]: 0\r\n'),
 (338,'2019-08-20 13:55:58','::1','admin','companies','edit','---Keys\r\ncompany_id : 3\r\n---Fields\r\nname [old]: Compañía 1\r\nname [new]: Company 1\r\n'),
 (339,'2019-08-20 13:56:35','::1','admin','departments','edit','---Keys\r\ndept_id : 1\r\n---Fields\r\nname [old]: Departamento 1\r\nname [new]: Departament 1\r\n'),
 (340,'2019-08-20 13:57:19','::1','admin','departments','add','---Keys\r\ndept_id : 2\r\n---Fields\r\ncompanies_company_id [new]: 4\r\nname [new]: Departament 2.1\r\ntype [new]: 0\r\n'),
 (341,'2019-08-20 13:57:35','::1','admin','departments','edit','---Keys\r\ndept_id : 1\r\n---Fields\r\nname [old]: Departament 1\r\nname [new]: Departament 1.1\r\n'),
 (342,'2019-08-20 13:58:48','::1','admin','users','add','---Keys\r\nuser_id : 5\r\n---Fields\r\ncompanies_company_id [new]: 4\r\ndepartments_dept_id [new]: 2\r\nlogin [new]: user2\r\nusername [new]: Usuario 2\r\npassword [new]: ee11cbb19052e40b07aac0ca060c23ee\r\nemail [new]: user2@fhumanes.com\r\ntype [new]: 0\r\n'),
 (343,'2019-08-20 13:59:15','::1','admin','users','logout',''),
 (344,'2019-08-20 13:59:23','::1','user1','users','login',''),
 (345,'2019-08-20 14:03:50','::1','user1','users','login',''),
 (346,'2019-08-20 14:08:54','::1','user1','users','logout',''),
 (347,'2019-08-20 14:09:05','::1','user1','users','login',''),
 (348,'2019-08-20 14:11:39','::1','user1','users','logout',''),
 (349,'2019-08-20 14:11:47','::1','admin','users','login',''),
 (350,'2019-08-20 14:14:53','::1','admin','users','login',''),
 (351,'2019-08-20 14:16:40','::1','admin','users','logout',''),
 (352,'2019-08-20 14:16:50','::1','user1','users','login',''),
 (353,'2019-08-20 14:17:12','::1','user1','users','logout',''),
 (354,'2019-08-20 14:17:22','::1','user2','users','login',''),
 (355,'2019-08-20 14:25:48','::1','user2','users','logout',''),
 (356,'2019-08-20 14:25:56','::1','user1','users','login',''),
 (357,'2019-08-20 14:32:48','::1','user1','users','logout',''),
 (358,'2019-08-20 14:32:56','::1','user2','users','login',''),
 (359,'2019-08-20 14:40:42','::1','user2','projects','edit','---Keys\r\nproject_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-18 16:11:53\r\nupdated [new]: 2019-08-20 14:40:42\r\nproject_updator [old]: 1\r\nproject_updator [new]: 5\r\nprivate [old]: 0\r\nprivate [new]: 1\r\n'),
 (360,'2019-08-20 14:40:55','::1','user2','projects','edit','---Keys\r\nproject_id : 3\r\n---Fields\r\nupdated [old]: 2019-08-18 16:09:32\r\nupdated [new]: 2019-08-20 14:40:55\r\nproject_updator [old]: 1\r\nproject_updator [new]: 5\r\nprivate [old]: 0\r\nprivate [new]: 1\r\n'),
 (361,'2019-08-20 14:40:58','::1','user2','users','logout',''),
 (362,'2019-08-20 14:41:13','::1','user2','users','login',''),
 (363,'2019-08-20 14:41:21','::1','user2','users','logout',''),
 (364,'2019-08-20 14:41:30','::1','user1','users','login',''),
 (365,'2019-08-20 15:33:39','::1','user1','users','logout',''),
 (366,'2019-08-20 15:33:48','::1','admin','users','login',''),
 (367,'2019-08-20 15:59:27','::1','admin','users','login',''),
 (368,'2019-08-20 16:08:54','::1','admin','users','edit','---Keys\r\nuser_id : 1\r\n---Fields\r\npassword [old]: 1e63dafa7e63f073ed2f362a49f8cf24\r\npassword [new]: 21232f297a57a5a743894a0e4a801fc3\r\n'),
 (369,'2019-08-20 16:09:15','::1','admin','users','edit','---Keys\r\nuser_id : 1\r\n---Fields\r\nemail [old]: user@domain.com\r\nemail [new]: adminr@fhumanes.com\r\n'),
 (370,'2019-08-20 18:08:27','::1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-19 20:14:16\r\nupdated [new]: 2019-08-20 18:08:27\r\ncreator [old]: 1\r\ncreator [new]: 5\r\n'),
 (371,'2019-08-20 18:08:50','::1','admin','users','logout',''),
 (372,'2019-08-20 18:09:03','::1','user1','users','login',''),
 (373,'2019-08-20 18:09:39','::1','user1','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-20 18:08:27\r\nupdated [new]: 2019-08-20 18:09:39\r\nupdator [old]: 1\r\nupdator [new]: 4\r\naccess [old]: 0\r\naccess [new]: 4\r\n'),
 (374,'2019-08-20 18:24:19','::1','user1','users','login',''),
 (375,'2019-08-20 18:41:04','::1','user1','users','logout',''),
 (376,'2019-08-20 18:41:22','::1','admin','users','failed login',''),
 (377,'2019-08-20 18:41:49','::1','admin','users','login',''),
 (378,'2019-08-20 18:43:56','::1','admin','users','logout',''),
 (379,'2019-08-20 18:44:06','::1','user1','users','login',''),
 (380,'2019-08-20 19:27:42','::1','user1','users','logout',''),
 (381,'2019-08-20 19:27:49','::1','admin','users','failed login',''),
 (382,'2019-08-20 19:27:54','::1','admin','users','login',''),
 (383,'2019-08-20 19:28:42','::1','admin','users','logout',''),
 (384,'2019-08-20 19:28:50','::1','user1','users','login',''),
 (385,'2019-08-20 19:37:17','::1','user1','users','logout',''),
 (386,'2019-08-20 19:37:25','::1','user2','users','login',''),
 (387,'2019-08-20 19:50:45','::1','admin','users','login',''),
 (388,'2019-08-20 19:53:38','::1','admin','users','logout',''),
 (389,'2019-08-20 19:53:46','::1','user2','users','failed login',''),
 (390,'2019-08-20 19:53:52','::1','user2','users','login',''),
 (391,'2019-08-20 19:54:42','::1','user2','users','login',''),
 (392,'2019-08-20 19:57:10','::1','user2','users','login',''),
 (393,'2019-08-20 19:57:19','::1','user2','users','logout',''),
 (394,'2019-08-20 19:57:27','::1','user1','users','login',''),
 (395,'2019-08-20 20:13:58','::1','user1','users','logout',''),
 (396,'2019-08-20 20:18:25','::1','admin','users','login',''),
 (397,'2019-08-20 22:32:13','::1','admin','users','logout',''),
 (398,'2019-08-21 11:43:39','::1','admin','users','login',''),
 (399,'2019-08-21 11:47:29','::1','admin','users','login',''),
 (400,'2019-08-21 16:31:04','::1','admin','users','login',''),
 (401,'2019-08-22 14:08:32','::1','admin','users','login',''),
 (402,'2019-08-22 15:46:25','::1','admin','users','logout',''),
 (403,'2019-08-22 15:46:33','::1','user1','users','login',''),
 (404,'2019-08-23 11:56:30','::1','admin','users','login',''),
 (405,'2019-08-23 11:58:15','::1','admin','task_log','add','---Keys\r\ntask_log_id : 48\r\n---Fields\r\ntasks_task_id [new]: 6\r\nname [new]: pruebas\r\ndate_day [new]: 2019-08-23\r\npercent_complete [new]: 0\r\ntask_end_date [new]: 2019-08-30\r\ncreator [new]: 1\r\ncreated [new]: 2019-08-23 11:57:54\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-23 11:57:54\r\n'),
 (406,'2019-08-23 12:01:48','::1','admin','task_log','add','---Keys\r\ntask_log_id : 49\r\n---Fields\r\ntasks_task_id [new]: 6\r\nname [new]: prueba\r\ndate_day [new]: 2019-08-23\r\nhours [new]: 10\r\npercent_complete [new]: 15\r\ntask_end_date [new]: 2019-08-30\r\ncreator [new]: 1\r\ncreated [new]: 2019-08-23 12:01:32\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-23 12:01:32\r\n'),
 (407,'2019-08-23 12:02:59','::1','admin','task_log','add','---Keys\r\ntask_log_id : 50\r\n---Fields\r\ntasks_task_id [new]: 6\r\nname [new]: prueba\r\ndate_day [new]: 2019-08-23\r\npercent_complete [new]: 20\r\ntask_end_date [new]: 2019-08-30\r\ncreator [new]: 1\r\ncreated [new]: 2019-08-23 12:02:42\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-23 12:02:42\r\n'),
 (408,'2019-08-23 12:08:05','::1','admin','task_log','add','---Keys\r\ntask_log_id : 51\r\n---Fields\r\ntasks_task_id [new]: 8\r\nname [new]: pruebas\r\ndate_day [new]: 2019-08-23\r\npercent_complete [new]: 20\r\ntask_end_date [new]: 2019-08-30\r\ncreator [new]: 1\r\ncreated [new]: 2019-08-23 12:07:51\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-23 12:07:51\r\n'),
 (409,'2019-08-23 12:08:43','::1','admin','task_log','add','---Keys\r\ntask_log_id : 52\r\n---Fields\r\ntasks_task_id [new]: 6\r\nname [new]: Pruebas\r\ndate_day [new]: 2019-08-23\r\npercent_complete [new]: 35\r\ntask_end_date [new]: 2019-08-30\r\ncreator [new]: 1\r\ncreated [new]: 2019-08-23 12:08:30\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-23 12:08:30\r\n'),
 (410,'2019-08-23 12:09:11','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 48\r\n---Fields\r\nname [old]: pruebas\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-23 11:57:54\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-23 11:57:54\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-23\r\npercent_complete [old]: 0\r\ntask_end_date [old]: 2019-08-30 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 6\r\n'),
 (411,'2019-08-23 12:09:11','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 49\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-23 12:01:32\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-23 12:01:32\r\nhours [old]: 10\r\ndate_day [old]: 2019-08-23\r\npercent_complete [old]: 15\r\ntask_end_date [old]: 2019-08-30 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 6\r\n'),
 (412,'2019-08-23 12:09:11','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 50\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-23 12:02:42\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-23 12:02:42\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-23\r\npercent_complete [old]: 20\r\ntask_end_date [old]: 2019-08-30 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 6\r\n'),
 (413,'2019-08-23 12:09:11','::1','admin','task_log','delete','---Keys\r\ntask_log_id : 52\r\n---Fields\r\nname [old]: Pruebas\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-23 12:08:30\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-23 12:08:30\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-23\r\npercent_complete [old]: 35\r\ntask_end_date [old]: 2019-08-30 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 6\r\n'),
 (414,'2019-08-23 12:09:45','::1','admin','task_log','add','---Keys\r\ntask_log_id : 53\r\n---Fields\r\ntasks_task_id [new]: 6\r\nname [new]: pruebas\r\ndate_day [new]: 2019-08-23\r\nhours [new]: 15\r\npercent_complete [new]: 40\r\ntask_end_date [new]: 2019-08-30\r\ncreator [new]: 1\r\ncreated [new]: 2019-08-23 12:09:28\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-23 12:09:28\r\n'),
 (415,'2019-08-23 12:10:13','::1','admin','task_log','add','---Keys\r\ntask_log_id : 54\r\n---Fields\r\ntasks_task_id [new]: 6\r\nname [new]: Pruebas\r\ndate_day [new]: 2019-08-23\r\nhours [new]: 15\r\npercent_complete [new]: 35\r\ntask_end_date [new]: 2019-08-30\r\ncreator [new]: 1\r\ncreated [new]: 2019-08-23 12:10:01\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-23 12:10:01\r\n'),
 (416,'2019-08-23 12:11:34','::1','admin','task_log','add','---Keys\r\ntask_log_id : 55\r\n---Fields\r\ntasks_task_id [new]: 8\r\nname [new]: Pruebas\r\ndate_day [new]: 2019-08-23\r\nhours [new]: 35\r\npercent_complete [new]: 50\r\ntask_end_date [new]: 2019-08-30\r\ncreator [new]: 1\r\ncreated [new]: 2019-08-23 12:11:18\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-23 12:11:18\r\n'),
 (417,'2019-08-23 12:16:10','::1','admin','task_log','add','---Keys\r\ntask_log_id : 56\r\n---Fields\r\ntasks_task_id [new]: 8\r\nname [new]: Pruebas\r\ndate_day [new]: 2019-08-23\r\nhours [new]: 20\r\npercent_complete [new]: 60\r\ntask_end_date [new]: 2019-08-30\r\ncreator [new]: 1\r\ncreated [new]: 2019-08-23 12:15:46\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-23 12:15:46\r\n'),
 (418,'2019-08-24 13:38:23','::1','admin','users','login',''),
 (419,'2019-08-24 13:38:55','::1','admin','task_log','add','---Keys\r\ntask_log_id : 57\r\n---Fields\r\ntasks_task_id [new]: 8\r\nname [new]: Prueba\r\ndate_day [new]: 2019-08-24\r\nhours [new]: 12\r\npercent_complete [new]: 65\r\ntask_end_date [new]: 2019-08-30\r\ncreator [new]: 1\r\ncreated [new]: 2019-08-24 13:38:39\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-24 13:38:39\r\n'),
 (420,'2019-08-24 13:43:11','::1','admin','users','login',''),
 (421,'2019-08-24 13:50:40','::1','admin','task_log','add','---Keys\r\ntask_log_id : 58\r\n---Fields\r\ntasks_task_id [new]: 6\r\nname [new]: prueba\r\ndate_day [new]: 2019-08-24\r\npercent_complete [new]: 15\r\ntask_end_date [new]: 2019-08-30\r\ncreator [new]: 1\r\ncreated [new]: 2019-08-24 13:50:34\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-24 13:50:34\r\n'),
 (422,'2019-08-24 13:51:21','::1','admin','task_log','add','---Keys\r\ntask_log_id : 59\r\n---Fields\r\ntasks_task_id [new]: 7\r\nname [new]: prueba\r\ndate_day [new]: 2019-08-24\r\npercent_complete [new]: 0\r\ntask_end_date [new]: 2019-08-23\r\ncreator [new]: 1\r\ncreated [new]: 2019-08-24 13:51:02\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-24 13:51:02\r\n'),
 (423,'2019-08-24 14:09:29','::1','admin','task_log','add','---Keys\r\ntask_log_id : 60\r\n---Fields\r\ntasks_task_id [new]: 8\r\nname [new]: Pruebas\r\ndate_day [new]: 2019-08-24\r\npercent_complete [new]: 65\r\ntask_end_date [new]: 2019-08-30\r\ndescription [new]: Pruebas\r\ncreator [new]: 1\r\ncreated [new]: 2019-08-24 14:09:14\r\nupdator [new]: 1\r\nupdated [new]: 2019-08-24 14:09:14\r\n'),
 (424,'2019-08-24 15:19:59','::1','admin','users','logout',''),
 (425,'2019-08-24 15:20:06','::1','user1','users','login',''),
 (426,'2019-08-24 15:21:01','::1','user1','projects','edit','---Keys\r\nproject_id : 3\r\n---Fields\r\nupdated [old]: 2019-08-20 14:40:55\r\nupdated [new]: 2019-08-24 15:21:01\r\nproject_updator [old]: 5\r\nproject_updator [new]: 4\r\nprivate [old]: 1\r\nprivate [new]: 3\r\n'),
 (427,'2019-08-24 15:22:15','::1','user1','users','logout',''),
 (428,'2019-08-24 15:22:21','::1','user1','users','login',''),
 (429,'2019-08-24 15:27:44','::1','user1','tasks','edit','---Keys\r\ntask_id : 11\r\n---Fields\r\nupdated [old]: 2019-08-19 17:03:10\r\nupdated [new]: 2019-08-24 15:27:44\r\nupdator [old]: 1\r\nupdator [new]: 4\r\naccess [old]: 0\r\naccess [new]: 4\r\n'),
 (430,'2019-08-24 16:34:58','::1','user1','users','logout',''),
 (431,'2019-08-24 16:35:05','::1','admin','users','login',''),
 (432,'2019-08-24 16:37:16','::1','admin','users','logout',''),
 (433,'2019-08-24 16:37:23','::1','user1','users','login',''),
 (434,'2019-08-24 16:38:58','::1','user1','files','add','---Keys\r\nfile_id : 2\r\n---Fields\r\nprojects_project_id [new]: 2\r\ntasks_task_id [new]: 8\r\ndescription [new]: pruebas\r\nfiles_content [new]: [{\"name\":\"files\\/2a96e7403aa1a9ee859064fed8e22d716a49915f7eb1df0c4955f3ca58e7e006_48mihp4v.jpg\",\"usrName\":\"2a96e7403aa1a9ee859064fed8e22d716a49915f7eb1df0c4955f3ca58e7e006.jpg\",\"size\":315483,\"type\":\"image\\/jpeg\",\"searchStr\":\"2a96e7403aa1a9ee859064fed8e22d716a49915f7eb1df0c4955f3ca58e7e006.jpg,!:sStr\r\n'),
 (435,'2019-08-24 16:47:05','::1','admin','users','login',''),
 (436,'2019-08-24 17:03:50','::1','user1','tasks','add','---Keys\r\ntask_id : 12\r\n---Fields\r\nprojects_project_id [new]: 2\r\npercent_complete [new]: 0\r\nname [new]: 4.- task 4\r\nmilestone [new]: 0\r\ndescription [new]: dedede\r\nstatus [new]: 0\r\ncreator [new]: 4\r\naccess [new]: 0\r\nstart_date [new]: 2019-08-27 08:00:00\r\nduration [new]: 3\r\nduration_type [new]: 0\r\nend_date [new]: 2019-08-29 17:00:00\r\nhours_worked [new]: 0\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2019-08-24 17:03:14\r\nupdator [new]: 4\r\nupdated [new]: 2019-08-24 17:03:14\r\n'),
 (437,'2019-08-24 17:04:14','::1','user1','tasks','delete','---Keys\r\ntask_id : 12\r\n---Fields\r\nprojects_project_id [old]: 2\r\nname [old]: 4.- task 4\r\nflag [old]: 4.- task 4\r\nmilestone [old]: 0\r\nstart_date [old]: 2019-08-27 08:00:00\r\nduration [old]: 3\r\nduration_type [old]: 0\r\nnatural_days [old]: 3\r\nhours_worked [old]: 0\r\nend_date [old]: 2019-08-29 17:00:00\r\nstatus [old]: 0\r\npercent_complete [old]: 0\r\ndescription [old]: dedede\r\ncreator [old]: 4\r\norder [old]: 8\r\nlevel [old]: 1\r\ndynamic [old]: 0\r\naccess [old]: 0\r\nnotify [old]: 0\r\ntype [old]: 0\r\nupdator [old]: 4\r\ncreated [old]: 2019-08-24 17:03:14\r\nupdated [old]: 2019-08-24 17:03:14\r\n'),
 (438,'2019-08-24 19:53:29','::1','admin','files','delete','---Keys\r\nfile_id : 2\r\n---Fields\r\nprojects_project_id [old]: 2\r\ntasks_task_id [old]: 8\r\ndescription [old]: pruebas\r\nfiles_content [old]: [{\"name\":\"files\\/2a96e7403aa1a9ee859064fed8e22d716a49915f7eb1df0c4955f3ca58e7e006_48mihp4v.jpg\",\"usrName\":\"2a96e7403aa1a9ee859064fed8e22d716a49915f7eb1df0c4955f3ca58e7e006.jpg\",\"size\":315483,\"type\":\"image\\/jpeg\",\"searchStr\":\"2a96e7403aa1a9ee859064fed8e22d716a49915f7eb1df0c4955f3ca58e7e006.jpg,!:sStr\r\n'),
 (439,'2019-08-24 19:57:32','::1','user1','users','logout',''),
 (440,'2019-08-24 19:57:40','::1','user2','users','login',''),
 (441,'2019-08-24 19:59:38','::1','user2','users','logout',''),
 (442,'2019-08-24 19:59:51','::1','user1','users','login',''),
 (443,'2019-08-24 20:00:50','::1','user1','files','add','---Keys\r\nfile_id : 3\r\n---Fields\r\nprojects_project_id [new]: 2\r\ntasks_task_id [new]: 8\r\ndescription [new]: Prueba\r\nfiles_content [new]: [{\"name\":\"files\\/dibujo_001_2g8o3zdc.jpg\",\"usrName\":\"dibujo_001.jpg\",\"size\":315483,\"type\":\"image\\/jpeg\",\"searchStr\":\"dibujo_001.jpg,!:sStrEnd\"}]\r\n'),
 (444,'2019-08-24 20:01:53','::1','user1','users','logout',''),
 (445,'2019-08-24 20:02:02','::1','user2','users','login',''),
 (446,'2019-08-24 20:12:30','::1','user2','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nupdated [old]: 2019-08-18 13:46:26\r\nupdated [new]: 2019-08-24 20:12:29\r\nupdator [old]: 1\r\nupdator [new]: 5\r\naccess [old]: 0\r\naccess [new]: 1\r\n'),
 (447,'2019-08-24 20:12:41','::1','user2','tasks','edit','---Keys\r\ntask_id : 5\r\n---Fields\r\nupdated [old]: 2019-08-17 17:18:55\r\nupdated [new]: 2019-08-24 20:12:41\r\nupdator [old]: 1\r\nupdator [new]: 5\r\naccess [old]: 0\r\naccess [new]: 1\r\n'),
 (448,'2019-08-24 20:12:49','::1','user2','tasks','edit','---Keys\r\ntask_id : 4\r\n---Fields\r\nupdated [old]: 2019-08-19 19:28:59\r\nupdated [new]: 2019-08-24 20:12:49\r\nupdator [old]: 1\r\nupdator [new]: 5\r\naccess [old]: 0\r\naccess [new]: 1\r\n'),
 (449,'2019-08-24 20:13:18','::1','user2','tasks','edit','---Keys\r\ntask_id : 6\r\n---Fields\r\nupdated [old]: 2019-08-17 16:08:56\r\nupdated [new]: 2019-08-24 20:13:18\r\nupdator [old]: 1\r\nupdator [new]: 5\r\naccess [old]: 0\r\naccess [new]: 1\r\n'),
 (450,'2019-08-24 20:13:28','::1','user2','tasks','edit','---Keys\r\ntask_id : 7\r\n---Fields\r\nupdated [old]: 2019-08-17 16:09:45\r\nupdated [new]: 2019-08-24 20:13:27\r\nupdator [old]: 1\r\nupdator [new]: 5\r\naccess [old]: 0\r\naccess [new]: 1\r\n'),
 (451,'2019-08-24 20:13:36','::1','user2','tasks','edit','---Keys\r\ntask_id : 8\r\n---Fields\r\nupdated [old]: 2019-08-17 16:11:10\r\nupdated [new]: 2019-08-24 20:13:36\r\nupdator [old]: 1\r\nupdator [new]: 5\r\naccess [old]: 0\r\naccess [new]: 1\r\n'),
 (452,'2019-08-24 20:21:59','::1','user2','users','logout',''),
 (453,'2019-08-24 20:22:08','::1','user1','users','login',''),
 (454,'2019-08-24 21:00:08','::1','user1','users','login',''),
 (455,'2019-08-24 22:28:47','::1','user1','users','logout',''),
 (456,'2019-08-24 22:29:08','::1','user1','users','login',''),
 (457,'2019-08-24 22:46:05','::1','user1','users','logout',''),
 (458,'2019-08-24 22:46:14','::1','user1','users','login',''),
 (459,'2019-08-24 23:07:18','::1','user1','users','logout',''),
 (460,'2019-08-24 23:07:25','::1','user1','users','login',''),
 (461,'2019-08-24 23:10:22','::1','user1','users','logout',''),
 (462,'2019-08-24 23:10:31','::1','user1','users','login',''),
 (463,'2019-08-24 23:12:31','::1','user1','users','logout',''),
 (464,'2019-08-24 23:12:39','::1','user1','users','login',''),
 (465,'2019-08-24 23:18:53','::1','user1','users','login',''),
 (466,'2019-08-24 23:30:27','::1','user1','users','logout',''),
 (467,'2019-08-24 23:30:53','::1','user1','users','login',''),
 (468,'2019-08-24 23:32:01','::1','user1','users','logout',''),
 (469,'2019-08-24 23:36:23','::1','admin','users','logout',''),
 (470,'2019-08-25 12:33:54','::1','users1','users','failed login',''),
 (471,'2019-08-25 12:34:00','::1','users1','users','failed login',''),
 (472,'2019-08-25 12:34:07','::1','user1','users','login',''),
 (473,'2019-08-25 13:39:50','::1','user1','users','logout',''),
 (474,'2019-09-08 13:07:40','::1','admin','users','login',''),
 (475,'2019-09-08 13:09:03','::1','admin','users','login',''),
 (476,'2019-09-08 13:20:25','::1','admin','users','login',''),
 (477,'2019-09-09 16:17:36','::1','admin','users','login',''),
 (478,'2020-07-10 18:41:54','::1','admin','users','login',''),
 (479,'2020-07-11 13:27:26','::1','admin','users','logout',''),
 (480,'2020-07-15 14:09:53','::1','admin','users','login',''),
 (481,'2020-12-17 18:31:15','127.0.0.1','admin','users','login',''),
 (482,'2020-12-18 11:40:02','127.0.0.1','admin','users','logout',''),
 (483,'2021-03-20 13:53:06','127.0.0.1','admin','users','login',''),
 (484,'2021-03-20 13:58:56','127.0.0.1','admin','users','logout',''),
 (485,'2021-06-28 13:26:39','127.0.0.1','admin','users','login',''),
 (486,'2022-01-18 20:11:23','127.0.0.1','admin','users','login',''),
 (487,'2022-01-19 20:09:08','127.0.0.1','admin','users','login',''),
 (488,'2022-01-19 21:05:58','127.0.0.1','admin','users','logout',''),
 (489,'2022-01-19 21:06:05','127.0.0.1','admin','users','login',''),
 (490,'2022-01-19 21:16:47','127.0.0.1','admin','task_log','add','---Keys\r\ntask_log_id : 61\r\n---Fields\r\ntasks_task_id [new]: 5\r\nname [new]: Test de funcionamiento\r\ndate_day [new]: 2022-01-19\r\nhours [new]: 8\r\npercent_complete [new]: 100\r\ncreator [new]: 1\r\ncreated [new]: 2022-01-19 21:16:16\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-19 21:16:16\r\n'),
 (491,'2022-01-19 21:31:44','127.0.0.1','admin','task_log','add','---Keys\r\ntask_log_id : 62\r\n---Fields\r\ntasks_task_id [new]: 5\r\nname [new]: Test de funcionamiento\r\ndate_day [new]: 2022-01-19\r\nhours [new]: 4\r\npercent_complete [new]: 100\r\ncreator [new]: 1\r\ncreated [new]: 2022-01-19 21:31:33\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-19 21:31:33\r\n'),
 (492,'2022-01-19 21:32:59','127.0.0.1','admin','task_log','add','---Keys\r\ntask_log_id : 63\r\n---Fields\r\ntasks_task_id [new]: 5\r\nname [new]: Test de funcionamiento\r\ndate_day [new]: 2022-01-19\r\nhours [new]: 4\r\npercent_complete [new]: 100\r\ncreator [new]: 1\r\ncreated [new]: 2022-01-19 21:32:50\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-19 21:32:50\r\n'),
 (493,'2022-01-19 21:33:29','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 61\r\n---Fields\r\nname [old]: Test de funcionamiento\r\ncreator [old]: 1\r\ncreated [old]: 2022-01-19 21:16:16\r\nupdator [old]: 1\r\nupdated [old]: 2022-01-19 21:16:16\r\nhours [old]: 8\r\ndate_day [old]: 2022-01-19\r\npercent_complete [old]: 100\r\nproblem [old]: 0\r\ntasks_task_id [old]: 5\r\n'),
 (494,'2022-01-19 21:33:29','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 62\r\n---Fields\r\nname [old]: Test de funcionamiento\r\ncreator [old]: 1\r\ncreated [old]: 2022-01-19 21:31:33\r\nupdator [old]: 1\r\nupdated [old]: 2022-01-19 21:31:33\r\nhours [old]: 4\r\ndate_day [old]: 2022-01-19\r\npercent_complete [old]: 100\r\nproblem [old]: 0\r\ntasks_task_id [old]: 5\r\n'),
 (495,'2022-01-20 18:22:32','127.0.0.1','admin','users','logout',''),
 (496,'2022-01-20 18:22:37','127.0.0.1','admin','users','login',''),
 (497,'2022-01-20 18:22:57','127.0.0.1','admin','users','logout',''),
 (498,'2022-01-20 18:23:00','127.0.0.1','admin','users','login',''),
 (499,'2022-01-20 18:23:39','127.0.0.1','admin','users','logout',''),
 (500,'2022-01-20 18:23:42','127.0.0.1','admin','users','login',''),
 (501,'2022-01-20 18:29:38','127.0.0.1','admin','users','logout',''),
 (502,'2022-01-20 18:29:41','127.0.0.1','admin','users','login',''),
 (503,'2022-01-20 18:30:34','127.0.0.1','admin','users','logout',''),
 (504,'2022-01-20 18:30:37','127.0.0.1','admin','users','login',''),
 (505,'2022-01-20 18:31:54','127.0.0.1','admin','users','logout',''),
 (506,'2022-01-20 18:31:56','127.0.0.1','admin','users','login',''),
 (507,'2022-01-20 19:01:15','127.0.0.1','admin','users','logout',''),
 (508,'2022-01-20 19:01:17','127.0.0.1','admin','users','login',''),
 (509,'2022-01-20 19:01:38','127.0.0.1','admin','users','login',''),
 (510,'2022-01-20 19:02:08','127.0.0.1','admin','users','logout',''),
 (511,'2022-01-20 19:02:17','127.0.0.1','user1','users','failed login',''),
 (512,'2022-01-20 19:02:35','127.0.0.1','user1','users','failed login',''),
 (513,'2022-01-20 19:02:46','127.0.0.1','admin','users','failed login',''),
 (514,'2022-01-20 19:02:53','127.0.0.1','admin','users','login',''),
 (515,'2022-01-20 19:03:14','127.0.0.1','admin','users','edit','---Keys\r\nuser_id : 4\r\n---Fields\r\npassword [old]: ee11cbb19052e40b07aac0ca060c23ee\r\npassword [new]: 24c9e15e52afc47c225b757e7bee1f9d\r\n'),
 (516,'2022-01-20 19:03:27','127.0.0.1','admin','users','edit','---Keys\r\nuser_id : 5\r\n---Fields\r\npassword [old]: ee11cbb19052e40b07aac0ca060c23ee\r\npassword [new]: 7e58d63b60197ceb55a1c487989a3720\r\n'),
 (517,'2022-01-20 19:03:30','127.0.0.1','admin','users','logout',''),
 (518,'2022-01-20 19:03:36','127.0.0.1','user1','users','login',''),
 (519,'2022-01-20 20:46:28','127.0.0.1','user1','users','logout',''),
 (520,'2022-01-20 20:46:33','127.0.0.1','admin','users','login',''),
 (521,'2022-01-20 20:47:57','127.0.0.1','admin','projects','edit','---Keys\r\nproject_id : 3\r\n---Fields\r\nshort_name [old]: P19/002\r\nshort_name [new]: P22/002\r\nend_date [old]: 2019-09-25 00:00:00\r\nend_date [new]: 2022-05-25 00:00:00\r\nupdated [old]: 2019-08-24 15:21:01\r\nupdated [new]: 2022-01-20 20:47:57\r\nstart_date [old]: 2019-08-13 00:00:00\r\nstart_date [new]: 2021-01-13 00:00:00\r\nproject_updator [old]: 4\r\nproject_updator [new]: 1\r\n'),
 (522,'2022-01-20 20:48:42','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 11\r\n---Fields\r\nupdated [old]: 2019-08-24 15:27:44\r\nupdated [new]: 2022-01-20 20:48:42\r\nupdator [old]: 4\r\nupdator [new]: 1\r\nend_date [old]: 2019-08-23 17:00:00\r\nend_date [new]: 2022-08-23 00:00:00\r\nstart_date [old]: 2019-08-19 08:00:00\r\nstart_date [new]: 2022-08-19 00:00:00\r\n'),
 (523,'2022-01-20 20:48:57','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 11\r\n---Fields\r\nupdated [old]: 2022-01-20 20:48:42\r\nupdated [new]: 2022-01-20 20:48:57\r\nend_date [old]: 2022-08-23 00:00:00\r\nend_date [new]: 2022-01-23 00:00:00\r\nstart_date [old]: 2022-08-19 00:00:00\r\nstart_date [new]: 2022-01-19 00:00:00\r\n'),
 (524,'2022-01-20 20:49:28','127.0.0.1','admin','projects','edit','---Keys\r\nproject_id : 3\r\n---Fields\r\nupdated [old]: 2022-01-20 20:47:57\r\nupdated [new]: 2022-01-20 20:49:28\r\n'),
 (525,'2022-01-20 20:50:13','127.0.0.1','admin','tasks','add','---Keys\r\ntask_id : 12\r\n---Fields\r\nprojects_project_id [new]: 3\r\npercent_complete [new]: 0\r\nname [new]: 1.- Task\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 3\r\nstart_date [new]: 2022-01-20 \r\nduration [new]: 10\r\nduration_type [new]: 0\r\nend_date [new]: 2022-01-29 \r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2022-01-20 20:49:42\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-20 20:49:42\r\n'),
 (526,'2022-01-20 20:54:25','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 12\r\n---Fields\r\nupdated [old]: 2022-01-20 20:49:42\r\nupdated [new]: 2022-01-20 20:54:25\r\nend_date [old]: 2022-01-29 00:00:00\r\nend_date [new]: 2022-02-02 00:00:00\r\nname [old]: 1.- Task\r\nname [new]: 2.- Task\r\nstart_date [old]: 2022-01-20 00:00:00\r\nstart_date [new]: 2022-01-24 00:00:00\r\n'),
 (527,'2022-01-20 20:59:36','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 12\r\n---Fields\r\nupdated [old]: 2022-01-20 20:54:25\r\nupdated [new]: 2022-01-20 20:59:36\r\nend_date [old]: 2022-02-02 00:00:00\r\nend_date [new]: 2022-02-07 00:00:00\r\nduration [old]: 10\r\nduration [new]: 15\r\n'),
 (528,'2022-01-20 21:02:38','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 12\r\n---Fields\r\nupdated [old]: 2022-01-20 20:59:36\r\nupdated [new]: 2022-01-20 21:02:38\r\nend_date [old]: 2022-02-07 00:00:00\r\nend_date [new]: 2022-02-04 00:00:00\r\nduration [old]: 15\r\nduration [new]: 12\r\n'),
 (529,'2022-01-20 21:07:03','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 12\r\n---Fields\r\nupdated [old]: 2022-01-20 21:02:38\r\nupdated [new]: 2022-01-20 21:07:03\r\nend_date [old]: 2022-02-04 00:00:00\r\nend_date [new]: 2022-02-05 00:00:00\r\nduration [old]: 12\r\nduration [new]: 13\r\n'),
 (530,'2022-01-20 21:20:34','127.0.0.1','admin','projects','edit','---Keys\r\nproject_id : 2\r\n---Fields\r\nend_date [old]: 2019-08-21 00:00:00\r\nend_date [new]: 2022-08-21 00:00:00\r\nupdated [old]: 2019-08-20 14:40:42\r\nupdated [new]: 2022-01-20 21:20:34\r\nstart_date [old]: 2019-07-25 00:00:00\r\nstart_date [new]: 2022-01-25 00:00:00\r\nproject_updator [old]: 5\r\nproject_updator [new]: 1\r\n'),
 (531,'2022-01-20 21:20:52','127.0.0.1','admin','files','delete','---Keys\r\nfile_id : 1\r\n---Fields\r\nprojects_project_id [old]: 2\r\ndescription [old]: Imagen\r\nfiles_content [old]: [{\"name\":\"files\\/fhumanes2_qx74uf3f.png\",\"usrName\":\"fhumanes2.png\",\"size\":80426,\"type\":\"image\\/png\",\"searchStr\":\"fhumanes2.png,!:sStrEnd\"}]\r\n'),
 (532,'2022-01-20 21:20:52','127.0.0.1','admin','files','delete','---Keys\r\nfile_id : 3\r\n---Fields\r\nprojects_project_id [old]: 2\r\ntasks_task_id [old]: 8\r\ndescription [old]: Prueba\r\nfiles_content [old]: [{\"name\":\"files\\/dibujo_001_2g8o3zdc.jpg\",\"usrName\":\"dibujo_001.jpg\",\"size\":315483,\"type\":\"image\\/jpeg\",\"searchStr\":\"dibujo_001.jpg,!:sStrEnd\"}]\r\n'),
 (533,'2022-01-20 21:21:28','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 24\r\n---Fields\r\nname [old]: Cierre\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 15:34:14\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 15:34:14\r\nhours [old]: 20\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-08-22 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 5\r\n'),
 (534,'2022-01-20 21:21:28','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 63\r\n---Fields\r\nname [old]: Test de funcionamiento\r\ncreator [old]: 1\r\ncreated [old]: 2022-01-19 21:32:50\r\nupdator [old]: 1\r\nupdated [old]: 2022-01-19 21:32:50\r\nhours [old]: 4\r\ndate_day [old]: 2022-01-19\r\npercent_complete [old]: 100\r\nproblem [old]: 0\r\ntasks_task_id [old]: 5\r\n'),
 (535,'2022-01-20 21:21:37','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 2\r\n---Fields\r\nname [old]: Avance correcto\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 13:01:43\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 13:01:43\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 35\r\ntask_end_date [old]: 2019-08-13 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 4\r\n'),
 (536,'2022-01-20 21:21:37','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 34\r\n---Fields\r\nname [old]: deede\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 19:30:44\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 19:30:44\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 35\r\ntask_end_date [old]: 2019-08-21 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 4\r\n'),
 (537,'2022-01-20 21:21:37','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 35\r\n---Fields\r\nname [old]: dddd\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 19:32:03\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 19:32:03\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 40\r\ntask_end_date [old]: 2019-08-21 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 4\r\n'),
 (538,'2022-01-20 21:21:45','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 41\r\n---Fields\r\nname [old]: sssss\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 19:47:50\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 19:47:50\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-09-04 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (539,'2022-01-20 21:21:45','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 42\r\n---Fields\r\nname [old]: dddd\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 20:15:31\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 20:15:31\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 85\r\ntask_end_date [old]: 2019-08-09 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (540,'2022-01-20 21:21:45','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 43\r\n---Fields\r\nname [old]: dede\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 20:17:19\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 20:17:19\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-08-12 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (541,'2022-01-20 21:21:45','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 44\r\n---Fields\r\nname [old]: ssss\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 20:22:17\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 20:22:17\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 80\r\ntask_end_date [old]: 2019-08-09 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (542,'2022-01-20 21:21:45','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 45\r\n---Fields\r\nname [old]: gtgtgt\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-19 20:33:07\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-19 20:33:07\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-19\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2019-08-13 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (543,'2022-01-20 21:21:55','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 53\r\n---Fields\r\nname [old]: pruebas\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-23 12:09:28\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-23 12:09:28\r\nhours [old]: 15\r\ndate_day [old]: 2019-08-23\r\npercent_complete [old]: 40\r\ntask_end_date [old]: 2019-08-30 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 6\r\n'),
 (544,'2022-01-20 21:21:55','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 54\r\n---Fields\r\nname [old]: Pruebas\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-23 12:10:01\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-23 12:10:01\r\nhours [old]: 15\r\ndate_day [old]: 2019-08-23\r\npercent_complete [old]: 35\r\ntask_end_date [old]: 2019-08-30 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 6\r\n'),
 (545,'2022-01-20 21:21:55','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 58\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-24 13:50:34\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-24 13:50:34\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-24\r\npercent_complete [old]: 15\r\ntask_end_date [old]: 2019-08-30 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 6\r\n'),
 (546,'2022-01-20 21:22:07','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 46\r\n---Fields\r\nname [old]: sssa\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-22 00:00:00\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-22\r\npercent_complete [old]: 0\r\ntasks_task_id [old]: 7\r\n'),
 (547,'2022-01-20 21:22:07','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 47\r\n---Fields\r\nname [old]: dsdsds\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-22 00:00:00\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-22\r\npercent_complete [old]: 0\r\ntasks_task_id [old]: 7\r\n'),
 (548,'2022-01-20 21:22:07','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 59\r\n---Fields\r\nname [old]: prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-24 13:51:02\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-24 13:51:02\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-24\r\npercent_complete [old]: 0\r\ntask_end_date [old]: 2019-08-23 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 7\r\n'),
 (549,'2022-01-20 21:22:17','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 51\r\n---Fields\r\nname [old]: pruebas\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-23 12:07:51\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-23 12:07:51\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-23\r\npercent_complete [old]: 20\r\ntask_end_date [old]: 2019-08-30 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 8\r\n'),
 (550,'2022-01-20 21:22:17','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 55\r\n---Fields\r\nname [old]: Pruebas\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-23 12:11:18\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-23 12:11:18\r\nhours [old]: 35\r\ndate_day [old]: 2019-08-23\r\npercent_complete [old]: 50\r\ntask_end_date [old]: 2019-08-30 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 8\r\n'),
 (551,'2022-01-20 21:22:17','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 56\r\n---Fields\r\nname [old]: Pruebas\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-23 12:15:46\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-23 12:15:46\r\nhours [old]: 20\r\ndate_day [old]: 2019-08-23\r\npercent_complete [old]: 60\r\ntask_end_date [old]: 2019-08-30 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 8\r\n'),
 (552,'2022-01-20 21:22:17','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 57\r\n---Fields\r\nname [old]: Prueba\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-24 13:38:39\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-24 13:38:39\r\nhours [old]: 12\r\ndate_day [old]: 2019-08-24\r\npercent_complete [old]: 65\r\ntask_end_date [old]: 2019-08-30 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 8\r\n'),
 (553,'2022-01-20 21:22:17','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 60\r\n---Fields\r\nname [old]: Pruebas\r\ndescription [old]: Pruebas\r\ncreator [old]: 1\r\ncreated [old]: 2019-08-24 14:09:14\r\nupdator [old]: 1\r\nupdated [old]: 2019-08-24 14:09:14\r\nhours [old]: 0\r\ndate_day [old]: 2019-08-24\r\npercent_complete [old]: 65\r\ntask_end_date [old]: 2019-08-30 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 8\r\n'),
 (554,'2022-01-20 21:23:39','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 1\r\n---Fields\r\nupdated [old]: 2019-08-24 20:12:29\r\nupdated [new]: 2022-01-20 21:23:39\r\nupdator [old]: 5\r\nupdator [new]: 1\r\n'),
 (555,'2022-01-20 21:24:19','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 5\r\n---Fields\r\nupdated [old]: 2019-08-24 20:12:41\r\nupdated [new]: 2022-01-20 21:24:19\r\nupdator [old]: 5\r\nupdator [new]: 1\r\nend_date [old]: 2019-08-19 17:00:00\r\nend_date [new]: 2022-01-19 17:00:00\r\nstart_date [old]: 2019-08-06 08:00:00\r\nstart_date [new]: 2022-01-06 08:00:00\r\n'),
 (556,'2022-01-20 21:24:49','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 4\r\n---Fields\r\nupdated [old]: 2019-08-24 20:12:49\r\nupdated [new]: 2022-01-20 21:24:49\r\nupdator [old]: 5\r\nupdator [new]: 1\r\nend_date [old]: 2019-09-02 17:00:00\r\nend_date [new]: 2022-02-02 17:00:00\r\nstart_date [old]: 2019-08-13 08:00:00\r\nstart_date [new]: 2022-01-13 08:00:00\r\n');
INSERT INTO `project_audit` (`id`,`datetime`,`ip`,`user`,`table`,`action`,`description`) VALUES 
 (557,'2022-01-20 21:25:36','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 5\r\n---Fields\r\nupdated [old]: 2022-01-20 21:24:19\r\nupdated [new]: 2022-01-20 21:25:36\r\nend_date [old]: 2022-01-19 17:00:00\r\nend_date [new]: 2022-02-16 17:00:00\r\nstart_date [old]: 2022-01-06 08:00:00\r\nstart_date [new]: 2022-02-03 08:00:00\r\n'),
 (558,'2022-01-20 21:26:20','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2019-08-20 18:09:39\r\nupdated [new]: 2022-01-20 21:26:20\r\nupdator [old]: 4\r\nupdator [new]: 1\r\nend_date [old]: 2019-08-09 17:00:00\r\nend_date [new]: 2022-02-16 17:00:00\r\nstart_date [old]: 2019-08-08 08:00:00\r\nstart_date [new]: 2022-02-15 08:00:00\r\n'),
 (559,'2022-01-21 13:56:57','127.0.0.1','admin','users','logout',''),
 (560,'2022-01-21 13:57:02','127.0.0.1','admin','users','login',''),
 (561,'2022-01-21 13:57:56','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 8\r\n---Fields\r\nupdated [old]: 2019-08-24 20:13:36\r\nupdated [new]: 2022-01-21 13:57:56\r\nupdator [old]: 5\r\nupdator [new]: 1\r\nend_date [old]: 2019-08-30 17:00:00\r\nend_date [new]: 2022-02-01 17:00:00\r\nstart_date [old]: 2019-08-28 08:00:00\r\nstart_date [new]: 2022-01-28 08:00:00\r\n'),
 (562,'2022-01-21 13:58:28','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 7\r\n---Fields\r\nupdated [old]: 2019-08-24 20:13:27\r\nupdated [new]: 2022-01-21 13:58:28\r\nupdator [old]: 5\r\nupdator [new]: 1\r\n'),
 (563,'2022-01-21 13:59:00','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 7\r\n---Fields\r\nupdated [old]: 2022-01-21 13:58:28\r\nupdated [new]: 2022-01-21 13:59:00\r\n'),
 (564,'2022-01-21 13:59:49','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 7\r\n---Fields\r\nupdated [old]: 2022-01-21 13:59:00\r\nupdated [new]: 2022-01-21 13:59:49\r\nend_date [old]: 2019-08-23 17:00:00\r\nend_date [new]: 2022-03-04 17:00:00\r\nstart_date [old]: 2019-08-12 08:00:00\r\nstart_date [new]: 2022-02-21 08:00:00\r\n'),
 (565,'2022-01-21 14:02:36','127.0.0.1','admin','task_log','add','---Keys\r\ntask_log_id : 64\r\n---Fields\r\ntasks_task_id [new]: 8\r\nname [new]: .\r\ndate_day [new]: 2022-01-21\r\npercent_complete [new]: 0\r\ncreator [new]: 1\r\ncreated [new]: 2022-01-21 14:01:51\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-21 14:01:51\r\n'),
 (566,'2022-01-21 14:03:22','127.0.0.1','admin','task_log','add','---Keys\r\ntask_log_id : 65\r\n---Fields\r\ntasks_task_id [new]: 4\r\nname [new]: .\r\ndate_day [new]: 2022-01-21\r\npercent_complete [new]: 0\r\ncreator [new]: 1\r\ncreated [new]: 2022-01-21 14:02:54\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-21 14:02:54\r\n'),
 (567,'2022-01-21 14:04:30','127.0.0.1','admin','task_log','add','---Keys\r\ntask_log_id : 66\r\n---Fields\r\ntasks_task_id [new]: 5\r\nname [new]: .\r\ndate_day [new]: 2022-01-21\r\npercent_complete [new]: 0\r\ntask_end_date [new]: 2022-02-15\r\ncreator [new]: 1\r\ncreated [new]: 2022-01-21 14:03:42\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-21 14:03:42\r\n'),
 (568,'2022-01-21 14:04:48','127.0.0.1','admin','task_log','add','---Keys\r\ntask_log_id : 67\r\n---Fields\r\ntasks_task_id [new]: 2\r\nname [new]: .\r\ndate_day [new]: 2022-01-21\r\npercent_complete [new]: 0\r\ntask_end_date [new]: 2022-02-16\r\ncreator [new]: 1\r\ncreated [new]: 2022-01-21 14:04:39\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-21 14:04:39\r\n'),
 (569,'2022-01-21 14:05:32','127.0.0.1','admin','task_log','edit','---Keys\r\ntask_log_id : 67\r\n---Fields\r\ntask_end_date [old]: 2022-02-16 00:00:00\r\ntask_end_date [new]: \r\nupdated [old]: 2022-01-21 14:04:39\r\nupdated [new]: 2022-01-21 14:05:32\r\n'),
 (570,'2022-01-21 14:07:56','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2022-01-20 21:26:20\r\nupdated [new]: 2022-01-21 14:07:56\r\nend_date [old]: 2022-02-16 17:00:00\r\nend_date [new]: 2022-01-18 17:00:00\r\nstart_date [old]: 2022-02-15 08:00:00\r\nstart_date [new]: 2022-01-17 08:00:00\r\n'),
 (571,'2022-01-21 14:08:34','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2022-01-21 14:07:56\r\nupdated [new]: 2022-01-21 14:08:34\r\nend_date [old]: 2022-01-18 17:00:00\r\nend_date [new]: 2022-01-24 17:00:00\r\nstart_date [old]: 2022-01-17 08:00:00\r\nstart_date [new]: 2022-01-21 08:00:00\r\n'),
 (572,'2022-01-21 17:43:19','127.0.0.1','admin','task_log','add','---Keys\r\ntask_log_id : 68\r\n---Fields\r\ntasks_task_id [new]: 2\r\nname [new]: .\r\ndate_day [new]: 2022-01-21\r\npercent_complete [new]: 100\r\ntask_end_date [new]: 2022-01-24\r\ncreator [new]: 1\r\ncreated [new]: 2022-01-21 17:43:04\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-21 17:43:04\r\n'),
 (573,'2022-01-21 17:43:44','127.0.0.1','admin','task_log','add','---Keys\r\ntask_log_id : 69\r\n---Fields\r\ntasks_task_id [new]: 2\r\nname [new]: .\r\ndate_day [new]: 2022-01-21\r\npercent_complete [new]: 0\r\ntask_end_date [new]: 2022-01-24\r\ncreator [new]: 1\r\ncreated [new]: 2022-01-21 17:43:30\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-21 17:43:30\r\n'),
 (574,'2022-01-21 17:46:34','127.0.0.1','admin','task_log','add','---Keys\r\ntask_log_id : 70\r\n---Fields\r\ntasks_task_id [new]: 2\r\nname [new]: .\r\ndate_day [new]: 2022-01-21\r\npercent_complete [new]: 0\r\ntask_end_date [new]: 2022-01-24\r\ncreator [new]: 1\r\ncreated [new]: 2022-01-21 17:46:27\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-21 17:46:27\r\n'),
 (575,'2022-01-21 17:48:03','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 65\r\n---Fields\r\nname [old]: .\r\ncreator [old]: 1\r\ncreated [old]: 2022-01-21 14:02:54\r\nupdator [old]: 1\r\nupdated [old]: 2022-01-21 14:02:54\r\nhours [old]: 0\r\ndate_day [old]: 2022-01-21\r\npercent_complete [old]: 0\r\nproblem [old]: 0\r\ntasks_task_id [old]: 4\r\n'),
 (576,'2022-01-21 17:48:13','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 66\r\n---Fields\r\nname [old]: .\r\ncreator [old]: 1\r\ncreated [old]: 2022-01-21 14:03:42\r\nupdator [old]: 1\r\nupdated [old]: 2022-01-21 14:03:42\r\nhours [old]: 0\r\ndate_day [old]: 2022-01-21\r\npercent_complete [old]: 0\r\ntask_end_date [old]: 2022-02-15 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 5\r\n'),
 (577,'2022-01-21 17:48:23','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 67\r\n---Fields\r\nname [old]: .\r\ncreator [old]: 1\r\ncreated [old]: 2022-01-21 14:04:39\r\nupdator [old]: 1\r\nupdated [old]: 2022-01-21 14:05:32\r\nhours [old]: 0\r\ndate_day [old]: 2022-01-21\r\npercent_complete [old]: 0\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (578,'2022-01-21 17:48:23','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 68\r\n---Fields\r\nname [old]: .\r\ncreator [old]: 1\r\ncreated [old]: 2022-01-21 17:43:04\r\nupdator [old]: 1\r\nupdated [old]: 2022-01-21 17:43:04\r\nhours [old]: 0\r\ndate_day [old]: 2022-01-21\r\npercent_complete [old]: 100\r\ntask_end_date [old]: 2022-01-24 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (579,'2022-01-21 17:48:23','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 69\r\n---Fields\r\nname [old]: .\r\ncreator [old]: 1\r\ncreated [old]: 2022-01-21 17:43:30\r\nupdator [old]: 1\r\nupdated [old]: 2022-01-21 17:43:30\r\nhours [old]: 0\r\ndate_day [old]: 2022-01-21\r\npercent_complete [old]: 0\r\ntask_end_date [old]: 2022-01-24 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (580,'2022-01-21 17:48:23','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 70\r\n---Fields\r\nname [old]: .\r\ncreator [old]: 1\r\ncreated [old]: 2022-01-21 17:46:27\r\nupdator [old]: 1\r\nupdated [old]: 2022-01-21 17:46:27\r\nhours [old]: 0\r\ndate_day [old]: 2022-01-21\r\npercent_complete [old]: 0\r\ntask_end_date [old]: 2022-01-24 00:00:00\r\nproblem [old]: 0\r\ntasks_task_id [old]: 2\r\n'),
 (581,'2022-01-21 17:48:37','127.0.0.1','admin','task_log','delete','---Keys\r\ntask_log_id : 64\r\n---Fields\r\nname [old]: .\r\ncreator [old]: 1\r\ncreated [old]: 2022-01-21 14:01:51\r\nupdator [old]: 1\r\nupdated [old]: 2022-01-21 14:01:51\r\nhours [old]: 0\r\ndate_day [old]: 2022-01-21\r\npercent_complete [old]: 0\r\nproblem [old]: 0\r\ntasks_task_id [old]: 8\r\n'),
 (582,'2022-01-21 17:49:44','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2022-01-21 14:08:34\r\nupdated [new]: 2022-01-21 17:49:44\r\nend_date [old]: 2022-01-24 17:00:00\r\nend_date [new]: 2022-01-27 17:00:00\r\nduration [old]: 12\r\nduration [new]: 36\r\n'),
 (583,'2022-01-21 17:50:17','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2022-01-21 17:49:44\r\nupdated [new]: 2022-01-21 17:50:17\r\nend_date [old]: 2022-01-27 17:00:00\r\nend_date [new]: 2022-02-01 17:00:00\r\nstart_date [old]: 2022-01-21 08:00:00\r\nstart_date [new]: 2022-01-26 08:00:00\r\n'),
 (584,'2022-01-21 20:10:00','127.0.0.1','admin','tasks','add','---Keys\r\ntask_id : 13\r\n---Fields\r\nprojects_project_id [new]: 2\r\npercent_complete [new]: 0\r\nname [new]: 4.- Task 4\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2022-03-01 08:00:00\r\nduration [new]: 14\r\nduration_type [new]: 0\r\nend_date [new]: 2022-03-18 17:00:00\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2022-01-21 20:09:05\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-21 20:09:05\r\n'),
 (585,'2022-01-21 20:10:29','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 13\r\n---Fields\r\nupdated [old]: 2022-01-21 20:09:05\r\nupdated [new]: 2022-01-21 20:10:29\r\nend_date [old]: 2022-03-18 17:00:00\r\nend_date [new]: 2022-01-28 17:00:00\r\nstart_date [old]: 2022-03-01 08:00:00\r\nstart_date [new]: 2022-01-11 08:00:00\r\n'),
 (586,'2022-01-21 20:10:52','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 13\r\n---Fields\r\nupdated [old]: 2022-01-21 20:10:29\r\nupdated [new]: 2022-01-21 20:10:52\r\nend_date [old]: 2022-01-28 17:00:00\r\nend_date [new]: 2022-03-18 17:00:00\r\nstart_date [old]: 2022-01-11 08:00:00\r\nstart_date [new]: 2022-03-01 08:00:00\r\n'),
 (587,'2022-01-21 20:11:56','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 4\r\n---Fields\r\nupdated [old]: 2022-01-20 21:24:49\r\nupdated [new]: 2022-01-21 20:11:55\r\ndependent [old]: 2\r\ndependent [new]: \r\n'),
 (588,'2022-01-21 20:12:06','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 5\r\n---Fields\r\nupdated [old]: 2022-01-20 21:25:36\r\nupdated [new]: 2022-01-21 20:12:06\r\ndependent [old]: \r\ndependent [new]: 2\r\n'),
 (589,'2022-01-21 20:13:13','127.0.0.1','admin','task_log','add','---Keys\r\ntask_log_id : 71\r\n---Fields\r\ntasks_task_id [new]: 4\r\nname [new]: Informe semanal\r\ndate_day [new]: 2022-01-21\r\nhours [new]: 10\r\npercent_complete [new]: 25\r\ntask_end_date [new]: 2022-02-11\r\ncreator [new]: 1\r\ncreated [new]: 2022-01-21 20:12:49\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-21 20:12:49\r\n'),
 (590,'2022-01-23 19:35:00','127.0.0.1','admin','tasks','add','---Keys\r\ntask_id : 14\r\n---Fields\r\nprojects_project_id [new]: 2\r\npercent_complete [new]: 0\r\nname [new]: 5.- Task 5\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 5\r\naccess [new]: 4\r\nstart_date [new]: 2022-01-24 08:00:00\r\nduration [new]: 5\r\nduration_type [new]: 0\r\nend_date [new]: 2022-01-28 17:00:00\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2022-01-23 19:34:21\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-23 19:34:21\r\n'),
 (591,'2022-01-23 19:36:25','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 14\r\n---Fields\r\nupdated [old]: 2022-01-23 19:34:21\r\nupdated [new]: 2022-01-23 19:36:25\r\nend_date [old]: 2022-01-28 17:00:00\r\nend_date [new]: 2022-03-11 17:00:00\r\nstart_date [old]: 2022-01-24 08:00:00\r\nstart_date [new]: 2022-03-07 08:00:00\r\n'),
 (592,'2022-01-23 19:37:10','127.0.0.1','admin','users','logout',''),
 (593,'2022-01-23 19:37:23','127.0.0.1','user2','users','login',''),
 (594,'2022-01-23 19:38:24','127.0.0.1','user2','tasks','edit','---Keys\r\ntask_id : 13\r\n---Fields\r\nupdated [old]: 2022-01-21 20:10:52\r\nupdated [new]: 2022-01-23 19:38:24\r\nupdator [old]: 1\r\nupdator [new]: 5\r\naccess [old]: 0\r\naccess [new]: 3\r\n'),
 (595,'2022-01-23 19:57:12','127.0.0.1','user2','task_log','add','---Keys\r\ntask_log_id : 72\r\n---Fields\r\ntasks_task_id [new]: 2\r\nname [new]: Marcado de problema\r\ndate_day [new]: 2022-01-23\r\nhours [new]: 10\r\npercent_complete [new]: 10\r\ntask_end_date [new]: 2022-02-01\r\nproblem [new]: 1\r\ndescription [new]: Descripción del problema\r\ncreator [new]: 5\r\ncreated [new]: 2022-01-23 19:56:25\r\nupdator [new]: 5\r\nupdated [new]: 2022-01-23 19:56:25\r\n'),
 (596,'2022-01-23 20:33:07','127.0.0.1','user2','user_tasks','edit','---Keys\r\nuser_task_id : 1\r\n'),
 (597,'2022-01-24 12:54:06','127.0.0.1','user2','task_log','edit','---Keys\r\ntask_log_id : 72\r\n---Fields\r\nupdated [old]: 2022-01-23 19:56:25\r\nupdated [new]: 2022-01-24 12:54:05\r\nproblem [old]: 1\r\nproblem [new]: 0\r\n'),
 (598,'2022-01-24 12:54:40','127.0.0.1','user2','task_log','edit','---Keys\r\ntask_log_id : 72\r\n---Fields\r\nupdated [old]: 2022-01-24 12:54:05\r\nupdated [new]: 2022-01-24 12:54:40\r\nproblem [old]: 0\r\nproblem [new]: 1\r\n'),
 (599,'2022-01-24 12:55:46','127.0.0.1','user2','users','logout',''),
 (600,'2022-01-24 12:55:50','127.0.0.1','admin','users','login',''),
 (601,'2022-01-24 12:56:53','127.0.0.1','admin','tasks','add','---Keys\r\ntask_id : 15\r\n---Fields\r\nprojects_project_id [new]: 2\r\npercent_complete [new]: 0\r\nname [new]: 1.2.1.- Task 1.2.1\r\nmilestone [new]: 0\r\ndescription [new]: Ejemplo de 3º nivel\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2022-02-08 08:00:00\r\nduration [new]: 15\r\nduration_type [new]: 0\r\nend_date [new]: 2022-02-28 17:00:00\r\nparent [new]: 5\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2022-01-24 12:56:02\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-24 12:56:02\r\n'),
 (602,'2022-01-24 12:58:01','127.0.0.1','admin','tasks','add','---Keys\r\ntask_id : 16\r\n---Fields\r\nprojects_project_id [new]: 2\r\npercent_complete [new]: 0\r\nname [new]: 1.2.2.- Task 1.2.2\r\nmilestone [new]: 0\r\ndescription [new]: Description task 1.2.2\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 0\r\nstart_date [new]: 2022-02-16 08:00:00\r\nduration [new]: 12\r\nduration_type [new]: 0\r\nend_date [new]: 2022-03-03 17:00:00\r\nparent [new]: 5\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2022-01-24 12:57:21\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-24 12:57:21\r\n'),
 (603,'2022-01-24 12:58:31','127.0.0.1','admin','task_log','add','---Keys\r\ntask_log_id : 73\r\n---Fields\r\ntasks_task_id [new]: 16\r\nname [new]: .\r\ndate_day [new]: 2022-01-24\r\nhours [new]: 14\r\npercent_complete [new]: 15\r\ntask_end_date [new]: 2022-03-03\r\ncreator [new]: 1\r\ncreated [new]: 2022-01-24 12:58:17\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-24 12:58:17\r\n'),
 (604,'2022-01-24 13:09:41','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 15\r\n---Fields\r\nupdated [old]: 2022-01-24 12:56:02\r\nupdated [new]: 2022-01-24 13:09:41\r\ndependent [old]: \r\ndependent [new]: 2\r\n'),
 (605,'2022-01-24 13:10:51','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 5\r\n---Fields\r\nupdated [old]: 2022-01-21 20:12:06\r\nupdated [new]: 2022-01-24 13:10:51\r\ndependent [old]: 2\r\ndependent [new]: \r\n'),
 (606,'2022-01-24 13:15:25','127.0.0.1','admin','projects','edit','---Keys\r\nproject_id : 2\r\n---Fields\r\nname [old]: Ejemplo del primer proyecto con el fin de hacer pruebas\r\nname [new]: This example has been updated to check the new features.\r\nupdated [old]: 2022-01-20 21:20:34\r\nupdated [new]: 2022-01-24 13:15:25\r\n'),
 (607,'2022-01-24 14:08:17','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 16\r\n---Fields\r\nupdated [old]: 2022-01-24 12:57:21\r\nupdated [new]: 2022-01-24 14:08:17\r\nend_date [old]: 2022-03-03 17:00:00\r\nend_date [new]: 2022-03-02 17:00:00\r\nstart_date [old]: 2022-02-16 08:00:00\r\nstart_date [new]: 2022-02-15 08:00:00\r\n'),
 (608,'2022-01-24 14:16:10','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 16\r\n---Fields\r\nupdated [old]: 2022-01-24 14:08:17\r\nupdated [new]: 2022-01-24 14:10:25\r\nstart_date [old]: 2022-02-15 08:00:00\r\nstart_date [new]: 2022-02-14 08:00:00\r\n'),
 (609,'2022-01-24 16:53:01','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 16\r\n---Fields\r\nupdated [old]: 2022-01-24 14:10:25\r\nupdated [new]: 2022-01-24 16:53:01\r\nend_date [old]: 2022-03-02 17:00:00\r\nend_date [new]: 1970-01-16 17:00:00\r\nstart_date [old]: 2022-02-14 08:00:00\r\nstart_date [new]: \r\n'),
 (610,'2022-01-24 20:54:50','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 16\r\n---Fields\r\nupdated [old]: 2022-01-24 16:53:01\r\nupdated [new]: 2022-01-24 20:53:13\r\nend_date [old]: 1970-01-16 17:00:00\r\nend_date [new]: 2022-03-02 17:00:00\r\nstart_date [old]: 0000-00-00 00:00:00\r\nstart_date [new]: 2022-02-14 00:00:00\r\n'),
 (611,'2022-01-24 21:08:22','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 16\r\n---Fields\r\nupdated [old]: 2022-01-24 20:53:13\r\nupdated [new]: 2022-01-24 20:56:17\r\nstart_date [old]: 0000-00-00 00:00:00\r\nstart_date [new]: 2022-02-14 00:00:00\r\n'),
 (612,'2022-01-24 21:09:20','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 16\r\n---Fields\r\nupdated [old]: 2022-01-24 20:56:17\r\nupdated [new]: 2022-01-24 21:08:43\r\nstart_date [old]: 0000-00-00 00:00:00\r\nstart_date [new]: 2022-02-14 08:00:00\r\n'),
 (613,'2022-01-24 21:10:01','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 16\r\n---Fields\r\nupdated [old]: 2022-01-24 21:08:43\r\nupdated [new]: 2022-01-24 21:09:51\r\n'),
 (614,'2022-01-24 21:16:25','127.0.0.1','admin','tasks','add','---Keys\r\ntask_id : 17\r\n---Fields\r\nprojects_project_id [new]: 2\r\npercent_complete [new]: 0\r\nname [new]: 6.- Task 6\r\nmilestone [new]: 0\r\nstatus [new]: 0\r\ncreator [new]: 1\r\naccess [new]: 3\r\nstart_date [new]: 2022-03-15 08:00:00\r\nduration [new]: 25\r\nduration_type [new]: 0\r\nend_date [new]: 2022-04-20 17:00:00\r\norder [new]: 0\r\nlevel [new]: 1\r\ndynamic [new]: 0\r\ntype [new]: 0\r\nnotify [new]: 0\r\ncreated [new]: 2022-01-24 21:15:48\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-24 21:15:48\r\n'),
 (615,'2022-01-24 21:17:15','127.0.0.1','admin','tasks','delete','---Keys\r\ntask_id : 17\r\n---Fields\r\nprojects_project_id [old]: 2\r\nname [old]: 6.- Task 6\r\nflag [old]: 6.- Task 6\r\nmilestone [old]: 0\r\nstart_date [old]: 2022-03-15 08:00:00\r\nduration [old]: 25\r\nduration_type [old]: 0\r\nnatural_days [old]: 37\r\nhours_worked [old]: 0\r\nend_date [old]: 2022-04-20 17:00:00\r\nstatus [old]: 0\r\npercent_complete [old]: 0\r\ncreator [old]: 1\r\norder [old]: 12\r\nlevel [old]: 1\r\ndynamic [old]: 0\r\naccess [old]: 3\r\nnotify [old]: 0\r\ntype [old]: 0\r\nupdator [old]: 1\r\ncreated [old]: 2022-01-24 21:15:48\r\nupdated [old]: 2022-01-24 21:15:48\r\n'),
 (616,'2022-01-25 13:00:57','127.0.0.1','admin','users','logout',''),
 (617,'2022-01-25 13:01:00','127.0.0.1','admin','users','login',''),
 (618,'2022-01-25 13:01:49','127.0.0.1','admin','users','logout',''),
 (619,'2022-01-25 13:01:55','127.0.0.1','user1','users','login',''),
 (620,'2022-01-25 13:07:54','127.0.0.1','user1','users','logout',''),
 (621,'2022-01-25 13:08:02','127.0.0.1','admin','users','login',''),
 (622,'2022-01-25 13:08:36','127.0.0.1','admin','users','logout',''),
 (623,'2022-01-25 13:08:44','127.0.0.1','admin','users','login',''),
 (624,'2022-01-25 13:12:54','127.0.0.1','admin','users','logout',''),
 (625,'2022-01-25 13:13:02','127.0.0.1','user1','users','login',''),
 (626,'2022-01-25 13:19:01','127.0.0.1','user1','users','logout',''),
 (627,'2022-01-25 13:19:04','127.0.0.1','admin','users','login',''),
 (628,'2022-01-25 13:19:24','127.0.0.1','admin','users','login',''),
 (629,'2022-01-25 13:20:31','127.0.0.1','admin','users','logout',''),
 (630,'2022-01-25 13:20:39','127.0.0.1','user1','users','login',''),
 (631,'2022-01-25 13:30:33','127.0.0.1','user1','users','logout',''),
 (632,'2022-01-25 13:30:42','127.0.0.1','user2','users','login',''),
 (633,'2022-01-25 13:31:29','127.0.0.1','user2','tasks','edit','---Keys\r\ntask_id : 15\r\n---Fields\r\nupdated [old]: 2022-01-24 13:09:41\r\nupdated [new]: 2022-01-25 13:31:29\r\nupdator [old]: 1\r\nupdator [new]: 5\r\naccess [old]: 0\r\naccess [new]: 4\r\n'),
 (634,'2022-01-25 13:31:57','127.0.0.1','user2','tasks','edit','---Keys\r\ntask_id : 16\r\n---Fields\r\nupdated [old]: 2022-01-24 21:09:51\r\nupdated [new]: 2022-01-25 13:31:57\r\nupdator [old]: 1\r\nupdator [new]: 5\r\naccess [old]: 0\r\naccess [new]: 4\r\n'),
 (635,'2022-01-25 13:34:54','127.0.0.1','user2','users','logout',''),
 (636,'2022-01-25 13:54:04','127.0.0.1','admin','users','login',''),
 (637,'2022-01-25 13:58:05','127.0.0.1','admin','users','logout',''),
 (638,'2022-01-25 20:33:17','127.0.0.1','admin','users','login',''),
 (639,'2022-01-28 19:14:41','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 3\r\n---Fields\r\nusers_user_id [new]: 1\r\ntasks_task_id [new]: 4\r\ntype [new]: 0\r\nperc_assignment [new]: 25\r\nuser_task_priority [new]: 0\r\n'),
 (640,'2022-01-28 19:15:20','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 4\r\n---Fields\r\nusers_user_id [new]: 4\r\ntasks_task_id [new]: 4\r\ntype [new]: 0\r\nperc_assignment [new]: 50\r\nuser_task_priority [new]: 0\r\n'),
 (641,'2022-01-28 19:15:42','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 5\r\n---Fields\r\nusers_user_id [new]: 1\r\ntasks_task_id [new]: 15\r\ntype [new]: 0\r\nperc_assignment [new]: 25\r\nuser_task_priority [new]: 0\r\n'),
 (642,'2022-01-28 19:45:41','::1','admin','users','login',''),
 (643,'2022-01-28 20:15:08','127.0.0.1','admin','files','add','---Keys\r\nfile_id : 4\r\n---Fields\r\nprojects_project_id [new]: 2\r\ndescription [new]: deded\r\nfiles_content [new]: [{\"name\":\"files\\/buho invernal_pgg1lfie.jpg\",\"usrName\":\"buho invernal.jpg\",\"size\":328465,\"type\":\"image\\/jpeg\",\"searchStr\":\"buho invernal.jpg,!:sStrEnd\"}]\r\n'),
 (644,'2022-01-28 20:17:17','127.0.0.1','admin','files','delete','---Keys\r\nfile_id : 4\r\n---Fields\r\nprojects_project_id [old]: 2\r\ndescription [old]: deded\r\nfiles_content [old]: [{\"name\":\"files\\/buho invernal_pgg1lfie.jpg\",\"usrName\":\"buho invernal.jpg\",\"size\":328465,\"type\":\"image\\/jpeg\",\"searchStr\":\"buho invernal.jpg,!:sStrEnd\"}]\r\n'),
 (645,'2022-01-28 20:35:48','127.0.0.1','admin','task_log','add','---Keys\r\ntask_log_id : 74\r\n---Fields\r\ntasks_task_id [new]: 4\r\nname [new]: .\r\ndate_day [new]: 2022-01-28\r\nhours [new]: 5\r\npercent_complete [new]: 25\r\ntask_end_date [new]: 2022-02-11\r\ncreator [new]: 1\r\ncreated [new]: 2022-01-28 20:35:37\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-28 20:35:37\r\n'),
 (646,'2022-01-28 20:54:39','127.0.0.1','admin','files','add','---Keys\r\nfile_id : 5\r\n---Fields\r\nprojects_project_id [new]: 2\r\ndescription [new]: cccc\r\nfiles_content [new]: Tormenta_de_verano_Juan_Garcia_Hortelano.pdf\r\n'),
 (647,'2022-01-28 20:58:33','127.0.0.1','admin','files','delete','---Keys\r\nfile_id : 5\r\n---Fields\r\nprojects_project_id [old]: 2\r\ndescription [old]: cccc\r\nfiles_content [old]: Tormenta_de_verano_Juan_Garcia_Hortelano.pdf\r\n'),
 (648,'2022-01-28 20:59:09','127.0.0.1','admin','files','add','---Keys\r\nfile_id : 6\r\n---Fields\r\nprojects_project_id [new]: 2\r\ndescription [new]: frfr\r\nfiles_content [new]: Tormenta_de_verano_Juan_Garcia_Hortelano.pdf\r\n'),
 (649,'2022-01-28 20:59:38','127.0.0.1','admin','task_log','add','---Keys\r\ntask_log_id : 75\r\n---Fields\r\ntasks_task_id [new]: 4\r\nname [new]: .\r\ndate_day [new]: 2022-01-28\r\nhours [new]: 1\r\npercent_complete [new]: 25\r\ntask_end_date [new]: 2022-02-11\r\ncreator [new]: 1\r\ncreated [new]: 2022-01-28 20:59:29\r\nupdator [new]: 1\r\nupdated [new]: 2022-01-28 20:59:29\r\n'),
 (650,'2022-01-28 21:00:30','127.0.0.1','admin','files','add','---Keys\r\nfile_id : 7\r\n---Fields\r\nprojects_project_id [new]: 2\r\ntasks_task_id [new]: 1\r\ndescription [new]: gg\r\nfiles_content [new]: Tormenta_de_verano_Juan_Garcia_Hortelano.pdf\r\n'),
 (651,'2022-01-28 21:00:52','127.0.0.1','admin','files','delete','---Keys\r\nfile_id : 7\r\n---Fields\r\nprojects_project_id [old]: 2\r\ntasks_task_id [old]: 1\r\ndescription [old]: gg\r\nfiles_content [old]: Tormenta_de_verano_Juan_Garcia_Hortelano.pdf\r\n'),
 (652,'2022-01-28 21:02:02','127.0.0.1','admin','files','delete','---Keys\r\nfile_id : 6\r\n---Fields\r\nprojects_project_id [old]: 2\r\ndescription [old]: frfr\r\nfiles_content [old]: Tormenta_de_verano_Juan_Garcia_Hortelano.pdf\r\n'),
 (653,'2022-01-28 21:02:39','127.0.0.1','admin','files','add','---Keys\r\nfile_id : 8\r\n---Fields\r\nprojects_project_id [new]: 2\r\ndescription [new]: Ejemplo de fichero /buho Invernal)\r\nfiles_content [new]: [{\"name\":\"files\\/buho invernal_rhi6gbe2.jpg\",\"usrName\":\"buho invernal.jpg\",\"size\":328465,\"type\":\"image\\/jpeg\",\"searchStr\":\"buho invernal.jpg,!:sStrEnd\"}]\r\n'),
 (654,'2022-01-29 13:48:55','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 6\r\n---Fields\r\nusers_user_id [new]: 5\r\ntasks_task_id [new]: 5\r\ntype [new]: 0\r\nperc_assignment [new]: 25\r\nuser_task_priority [new]: 0\r\n'),
 (655,'2022-01-29 13:48:55','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 7\r\n---Fields\r\nusers_user_id [new]: 4\r\ntasks_task_id [new]: 5\r\ntype [new]: 0\r\nperc_assignment [new]: 25\r\nuser_task_priority [new]: 0\r\n'),
 (656,'2022-01-29 13:49:11','127.0.0.1','admin','user_tasks','delete','---Keys\r\nuser_task_id : 5\r\n---Fields\r\nusers_user_id [old]: 1\r\ntasks_task_id [old]: 15\r\ntype [old]: 0\r\nperc_assignment [old]: 25\r\nuser_task_priority [old]: 0\r\n'),
 (657,'2022-01-29 13:49:26','127.0.0.1','admin','user_tasks','delete','---Keys\r\nuser_task_id : 6\r\n---Fields\r\nusers_user_id [old]: 5\r\ntasks_task_id [old]: 5\r\ntype [old]: 0\r\nperc_assignment [old]: 25\r\nuser_task_priority [old]: 0\r\n'),
 (658,'2022-01-29 13:49:26','127.0.0.1','admin','user_tasks','delete','---Keys\r\nuser_task_id : 7\r\n---Fields\r\nusers_user_id [old]: 4\r\ntasks_task_id [old]: 5\r\ntype [old]: 0\r\nperc_assignment [old]: 25\r\nuser_task_priority [old]: 0\r\n'),
 (659,'2022-01-29 13:50:14','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 8\r\n---Fields\r\nusers_user_id [new]: 1\r\ntasks_task_id [new]: 15\r\ntype [new]: 0\r\nperc_assignment [new]: 25\r\nuser_task_priority [new]: 0\r\n'),
 (660,'2022-01-29 13:50:14','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 9\r\n---Fields\r\nusers_user_id [new]: 5\r\ntasks_task_id [new]: 15\r\ntype [new]: 0\r\nperc_assignment [new]: 25\r\nuser_task_priority [new]: 0\r\n'),
 (661,'2022-01-29 13:50:14','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 10\r\n---Fields\r\nusers_user_id [new]: 4\r\ntasks_task_id [new]: 15\r\ntype [new]: 0\r\nperc_assignment [new]: 25\r\nuser_task_priority [new]: 0\r\n'),
 (662,'2022-01-29 13:51:18','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 11\r\n---Fields\r\nusers_user_id [new]: 4\r\ntasks_task_id [new]: 16\r\ntype [new]: 0\r\nperc_assignment [new]: 50\r\nuser_task_priority [new]: 0\r\n'),
 (663,'2022-01-29 13:51:18','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 12\r\n---Fields\r\nusers_user_id [new]: 1\r\ntasks_task_id [new]: 16\r\ntype [new]: 0\r\nperc_assignment [new]: 15\r\nuser_task_priority [new]: 0\r\n'),
 (664,'2022-01-29 13:51:41','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 13\r\n---Fields\r\nusers_user_id [new]: 1\r\ntasks_task_id [new]: 2\r\ntype [new]: 0\r\nperc_assignment [new]: 10\r\nuser_task_priority [new]: 0\r\n'),
 (665,'2022-01-29 13:51:41','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 14\r\n---Fields\r\nusers_user_id [new]: 5\r\ntasks_task_id [new]: 2\r\ntype [new]: 0\r\nperc_assignment [new]: 100\r\nuser_task_priority [new]: 0\r\n'),
 (666,'2022-01-29 13:52:25','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 15\r\n---Fields\r\nusers_user_id [new]: 5\r\ntasks_task_id [new]: 8\r\ntype [new]: 0\r\nperc_assignment [new]: 50\r\nuser_task_priority [new]: 0\r\n'),
 (667,'2022-01-29 13:52:25','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 16\r\n---Fields\r\nusers_user_id [new]: 4\r\ntasks_task_id [new]: 8\r\ntype [new]: 0\r\nperc_assignment [new]: 50\r\nuser_task_priority [new]: 0\r\n'),
 (668,'2022-01-29 13:52:25','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 17\r\n---Fields\r\nusers_user_id [new]: 1\r\ntasks_task_id [new]: 8\r\ntype [new]: 0\r\nperc_assignment [new]: 15\r\nuser_task_priority [new]: 0\r\n'),
 (669,'2022-01-29 13:53:33','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 18\r\n---Fields\r\nusers_user_id [new]: 5\r\ntasks_task_id [new]: 7\r\ntype [new]: 0\r\nperc_assignment [new]: 25\r\nuser_task_priority [new]: 0\r\n'),
 (670,'2022-01-29 13:53:33','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 19\r\n---Fields\r\nusers_user_id [new]: 4\r\ntasks_task_id [new]: 7\r\ntype [new]: 0\r\nperc_assignment [new]: 25\r\nuser_task_priority [new]: 0\r\n'),
 (671,'2022-01-29 13:53:34','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 20\r\n---Fields\r\nusers_user_id [new]: 1\r\ntasks_task_id [new]: 7\r\ntype [new]: 0\r\nperc_assignment [new]: 10\r\nuser_task_priority [new]: 0\r\n'),
 (672,'2022-01-29 13:53:54','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 21\r\n---Fields\r\nusers_user_id [new]: 1\r\ntasks_task_id [new]: 13\r\ntype [new]: 0\r\nperc_assignment [new]: 100\r\nuser_task_priority [new]: 0\r\n'),
 (673,'2022-01-29 13:54:34','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 22\r\n---Fields\r\nusers_user_id [new]: 1\r\ntasks_task_id [new]: 14\r\ntype [new]: 0\r\nperc_assignment [new]: 10\r\nuser_task_priority [new]: 0\r\n'),
 (674,'2022-01-29 13:54:34','127.0.0.1','admin','user_tasks','add','---Keys\r\nuser_task_id : 23\r\n---Fields\r\nusers_user_id [new]: 5\r\ntasks_task_id [new]: 14\r\ntype [new]: 0\r\nperc_assignment [new]: 100\r\nuser_task_priority [new]: 0\r\n'),
 (675,'2022-01-30 14:31:45','127.0.0.1','admin','users','logout',''),
 (676,'2022-01-30 14:31:52','127.0.0.1','user1','users','login',''),
 (677,'2022-01-30 18:54:04','127.0.0.1','user1','users','logout',''),
 (678,'2022-01-30 18:54:12','127.0.0.1','user2','users','login',''),
 (679,'2022-01-30 19:49:43','127.0.0.1','user2','task_log','add','---Keys\r\ntask_log_id : 76\r\n---Fields\r\ntasks_task_id [new]: 15\r\nname [new]: .\r\ndate_day [new]: 2022-01-30\r\nhours [new]: 4\r\npercent_complete [new]: 5\r\ntask_end_date [new]: 2022-02-28\r\ncreator [new]: 5\r\ncreated [new]: 2022-01-30 19:49:22\r\nupdator [new]: 5\r\nupdated [new]: 2022-01-30 19:49:22\r\n'),
 (680,'2022-01-30 20:13:07','127.0.0.1','user2','files','add','---Keys\r\nfile_id : 9\r\n---Fields\r\nprojects_project_id [new]: 2\r\ntasks_task_id [new]: 2\r\ndescription [new]: Ejemplo de fichero asignado a tarea\r\nfiles_content [new]: [{\"name\":\"files\\/buho invernal_mu7eptir.jpg\",\"usrName\":\"buho invernal.jpg\",\"size\":328465,\"type\":\"image\\/jpeg\",\"searchStr\":\"buho invernal.jpg,!:sStrEnd\"}]\r\n'),
 (681,'2022-01-30 20:18:03','127.0.0.1','user2','users','logout',''),
 (682,'2022-01-30 20:18:06','127.0.0.1','admin','users','login',''),
 (683,'2022-01-30 20:20:31','127.0.0.1','admin','users','logout',''),
 (684,'2022-01-30 20:20:41','127.0.0.1','user2','users','login',''),
 (685,'2022-01-30 20:59:17','127.0.0.1','admin','users','login',''),
 (686,'2022-01-30 21:00:10','127.0.0.1','admin','users','logout',''),
 (687,'2022-01-31 13:32:24','127.0.0.1','user2','task_log','add','---Keys\r\ntask_log_id : 77\r\n---Fields\r\ntasks_task_id [new]: 4\r\nname [new]: fINALIZADA\r\ndate_day [new]: 2022-01-31\r\npercent_complete [new]: 100\r\ntask_end_date [new]: 2022-01-31\r\ncreator [new]: 5\r\ncreated [new]: 2022-01-31 13:31:56\r\nupdator [new]: 5\r\nupdated [new]: 2022-01-31 13:31:56\r\n'),
 (688,'2022-01-31 13:33:10','127.0.0.1','user2','users','logout',''),
 (689,'2022-01-31 13:33:13','127.0.0.1','admin','users','login',''),
 (690,'2022-02-02 20:08:19','127.0.0.1','admin','user_tasks','edit','---Keys\r\nuser_task_id : 2\r\n---Fields\r\nperc_assignment [old]: 100\r\nperc_assignment [new]: 10\r\n'),
 (691,'2022-02-02 20:09:17','127.0.0.1','admin','user_tasks','edit','---Keys\r\nuser_task_id : 14\r\n---Fields\r\nperc_assignment [old]: 100\r\nperc_assignment [new]: 50\r\n'),
 (692,'2022-02-02 20:37:35','127.0.0.1','admin','user_tasks','edit','---Keys\r\nuser_task_id : 1\r\n---Fields\r\nperc_assignment [old]: 100\r\nperc_assignment [new]: 15\r\n'),
 (693,'2022-02-03 21:15:19','127.0.0.1','admin','users','logout',''),
 (694,'2022-06-03 13:43:47','127.0.0.1','admin','users','login',''),
 (695,'2022-06-07 21:19:55','127.0.0.1','admin','users','login',''),
 (696,'2022-06-07 21:21:00','127.0.0.1','admin','users','logout',''),
 (697,'2022-06-07 21:21:09','127.0.0.1','user1','users','login',''),
 (698,'2022-06-08 12:25:11','127.0.0.1','user1','users','logout',''),
 (699,'2022-06-08 12:25:15','127.0.0.1','admin','users','login',''),
 (700,'2022-06-08 12:25:50','127.0.0.1','admin','users','logout',''),
 (701,'2022-06-08 12:26:19','127.0.0.1','admin','users','login',''),
 (702,'2022-06-08 12:27:41','127.0.0.1','admin','users','login',''),
 (703,'2022-07-20 17:36:15','127.0.0.1','admin','users','login',''),
 (704,'2022-07-20 18:07:16','127.0.0.1','admin','users','logout',''),
 (705,'2022-07-20 18:07:19','127.0.0.1','admin','users','login',''),
 (706,'2023-01-30 18:24:52','127.0.0.1','admin','users','login',''),
 (707,'2023-01-30 18:26:18','127.0.0.1','admin','files','delete','---Keys\r\nfile_id : 9\r\n---Fields\r\nprojects_project_id [old]: 2\r\ntasks_task_id [old]: 2\r\ndescription [old]: Ejemplo de fichero asignado a tarea\r\nfiles_content [old]: [{\"name\":\"files\\/buho invernal_mu7eptir.jpg\",\"usrName\":\"buho invernal.jpg\",\"size\":328465,\"type\":\"image\\/jpeg\",\"searchStr\":\"buho invernal.jpg,!:sStrEnd\"}]\r\n'),
 (708,'2023-01-30 20:07:29','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 4\r\n---Fields\r\nupdated [old]: 2022-01-21 20:11:55\r\nupdated [new]: 2023-01-30 20:07:29\r\nend_date [old]: 2022-02-11 17:00:00\r\nend_date [new]: 2023-02-13 17:00:00\r\nstart_date [old]: 2022-01-24 08:00:00\r\nstart_date [new]: 2023-01-24 08:00:00\r\n'),
 (709,'2023-01-30 20:07:51','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 15\r\n---Fields\r\nupdated [old]: 2022-01-25 13:31:29\r\nupdated [new]: 2023-01-30 20:07:51\r\nupdator [old]: 5\r\nupdator [new]: 1\r\nend_date [old]: 2022-02-28 17:00:00\r\nend_date [new]: 2023-02-28 17:00:00\r\nstart_date [old]: 2022-02-08 08:00:00\r\nstart_date [new]: 2023-02-08 08:00:00\r\n'),
 (710,'2023-01-30 20:08:07','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 16\r\n---Fields\r\nupdated [old]: 2022-01-25 13:31:57\r\nupdated [new]: 2023-01-30 20:08:07\r\nupdator [old]: 5\r\nupdator [new]: 1\r\nend_date [old]: 2022-03-02 17:00:00\r\nend_date [new]: 2023-03-01 17:00:00\r\nstart_date [old]: 2022-02-14 08:00:00\r\nstart_date [new]: 2023-02-14 08:00:00\r\n'),
 (711,'2023-01-30 20:08:21','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 2\r\n---Fields\r\nupdated [old]: 2022-01-21 17:50:17\r\nupdated [new]: 2023-01-30 20:08:21\r\nend_date [old]: 2022-02-01 17:00:00\r\nend_date [new]: 2023-02-01 17:00:00\r\nstart_date [old]: 2022-01-26 08:00:00\r\nstart_date [new]: 2023-01-26 08:00:00\r\n'),
 (712,'2023-01-30 20:08:30','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 8\r\n---Fields\r\nupdated [old]: 2022-01-21 13:57:56\r\nupdated [new]: 2023-01-30 20:08:30\r\nend_date [old]: 2022-02-01 17:00:00\r\nend_date [new]: 2023-01-31 17:00:00\r\nstart_date [old]: 2022-01-28 08:00:00\r\nstart_date [new]: 2023-01-28 08:00:00\r\n'),
 (713,'2023-01-30 20:08:41','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 7\r\n---Fields\r\nupdated [old]: 2022-01-21 13:59:49\r\nupdated [new]: 2023-01-30 20:08:41\r\nend_date [old]: 2022-03-04 17:00:00\r\nend_date [new]: 2023-03-06 17:00:00\r\nstart_date [old]: 2022-02-21 08:00:00\r\nstart_date [new]: 2023-02-21 08:00:00\r\n'),
 (714,'2023-01-30 20:09:07','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 13\r\n---Fields\r\nupdated [old]: 2022-01-23 19:38:24\r\nupdated [new]: 2023-01-30 20:09:07\r\nupdator [old]: 5\r\nupdator [new]: 1\r\nend_date [old]: 2022-03-18 17:00:00\r\nend_date [new]: 2023-03-20 17:00:00\r\nstart_date [old]: 2022-03-01 08:00:00\r\nstart_date [new]: 2023-03-01 08:00:00\r\n'),
 (715,'2023-01-30 20:09:16','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 14\r\n---Fields\r\nupdated [old]: 2022-01-23 19:36:25\r\nupdated [new]: 2023-01-30 20:09:16\r\nend_date [old]: 2022-03-11 17:00:00\r\nend_date [new]: 2023-03-13 17:00:00\r\nstart_date [old]: 2022-03-07 08:00:00\r\nstart_date [new]: 2023-03-07 08:00:00\r\n'),
 (716,'2023-01-30 20:10:55','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 11\r\n---Fields\r\nupdated [old]: 2022-01-20 20:48:57\r\nupdated [new]: 2023-01-30 20:10:55\r\nend_date [old]: 2022-01-23 00:00:00\r\nend_date [new]: 2023-01-25 17:00:00\r\nstart_date [old]: 2022-01-19 00:00:00\r\nstart_date [new]: 2023-01-19 08:00:00\r\n'),
 (717,'2023-01-30 20:11:03','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 12\r\n---Fields\r\nupdated [old]: 2022-01-20 21:07:03\r\nupdated [new]: 2023-01-30 20:11:03\r\nend_date [old]: 2022-02-05 00:00:00\r\nend_date [new]: 2023-02-09 17:00:00\r\nstart_date [old]: 2022-01-24 00:00:00\r\nstart_date [new]: 2023-01-24 08:00:00\r\n'),
 (718,'2023-01-31 13:55:32','127.0.0.1','admin','projects','edit','---Keys\r\nproject_id : 2\r\n---Fields\r\nupdated [old]: 2022-01-24 13:15:25\r\nupdated [new]: 2023-01-31 13:55:32\r\nproject_parent [old]: 0\r\nproject_parent [new]: 3\r\n'),
 (719,'2023-01-31 18:56:55','127.0.0.1','admin','projects','edit','---Keys\r\nproject_id : 3\r\n---Fields\r\nupdated [old]: 2022-01-20 20:49:28\r\nupdated [new]: 2023-01-31 18:56:55\r\nproject_parent [old]: 0\r\nproject_parent [new]: 2\r\n'),
 (720,'2023-01-31 18:57:11','127.0.0.1','admin','projects','edit','---Keys\r\nproject_id : 2\r\n---Fields\r\nupdated [old]: 2023-01-31 13:55:32\r\nupdated [new]: 2023-01-31 18:57:11\r\nproject_parent [old]: 3\r\nproject_parent [new]: \r\n'),
 (721,'2023-01-31 19:20:32','127.0.0.1','admin','projects','edit','---Keys\r\nproject_id : 3\r\n---Fields\r\nend_date [old]: 2022-05-25 00:00:00\r\nend_date [new]: 2023-05-25 00:00:00\r\nupdated [old]: 2023-01-31 18:56:55\r\nupdated [new]: 2023-01-31 19:20:32\r\nstart_date [old]: 2021-01-13 00:00:00\r\nstart_date [new]: 2023-01-13 00:00:00\r\n'),
 (722,'2023-01-31 19:59:08','127.0.0.1','admin','tasks','edit','---Keys\r\ntask_id : 12\r\n---Fields\r\nupdated [old]: 2023-01-30 20:11:03\r\nupdated [new]: 2023-01-31 19:59:08\r\n'),
 (723,'2023-01-31 21:16:18','127.0.0.1','admin','users','logout','');
/*!40000 ALTER TABLE `project_audit` ENABLE KEYS */;


--
-- Definition of table `project_locking`
--

DROP TABLE IF EXISTS `project_locking`;
CREATE TABLE `project_locking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `table` varchar(300) NOT NULL,
  `startdatetime` datetime NOT NULL,
  `confirmdatetime` datetime NOT NULL,
  `keys` varchar(300) NOT NULL,
  `sessionid` varchar(100) NOT NULL,
  `userid` varchar(300) NOT NULL,
  `action` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `project_locking`
--

/*!40000 ALTER TABLE `project_locking` DISABLE KEYS */;
/*!40000 ALTER TABLE `project_locking` ENABLE KEYS */;


--
-- Definition of table `project_settings`
--

DROP TABLE IF EXISTS `project_settings`;
CREATE TABLE `project_settings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TYPE` int(11) DEFAULT '1',
  `NAME` mediumtext,
  `USERNAME` mediumtext,
  `COOKIE` varchar(500) DEFAULT NULL,
  `SEARCH` mediumtext,
  `TABLENAME` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `project_settings`
--

/*!40000 ALTER TABLE `project_settings` DISABLE KEYS */;
INSERT INTO `project_settings` (`ID`,`TYPE`,`NAME`,`USERNAME`,`COOKIE`,`SEARCH`,`TABLENAME`) VALUES 
 (1,3,'0','admin',NULL,'[\".dummyField\",\"departments_dept_id\"]','projects'),
 (2,4,NULL,'admin',NULL,'[\"project_id\",\"color_identifier\",\"departments_dept_id\",\"short_name\",\"problem\",\"name\",\"owner\",\"companies_company_id\",\"start_date\",\"end_date\",\"actual_end_date\",\"status\",\"percent_complete\"]','projects'),
 (3,2,NULL,'admin',NULL,'{\"gridWidth\":1297.4,\"thWidths\":{\"grid_headcell_icons\":28.4,\"grid_headcell_checkbox\":16.4,\"grid_headcell_details\":104.4,\"grid_headcell_field\":50.4,\"grid_headcell_field8\":22.4,\"grid_headcell_field12\":37.4,\"grid_headcell_field2\":92.4,\"grid_headcell_field3\":67.4,\"grid_headcell_field11\":76.4,\"grid_headcell_field4\":57.4,\"grid_headcell_field5\":56.4,\"grid_headcell_field7\":43.4,\"grid_headcell_field9\":49.4,\"grid_headcell_field1\":58.4,\"grid_headcell_field10\":67.4,\"grid_headcell_field6\":40.4,\"grid_headcell_field13\":233.4}}','tasks'),
 (4,2,NULL,'user1',NULL,'{\"gridWidth\":1199.4,\"thWidths\":{\"grid_headcell_icons\":27.4,\"grid_headcell_checkbox\":19.4,\"grid_headcell_details\":115.4,\"grid_headcell_field\":63.4,\"grid_headcell_field8\":30.4,\"grid_headcell_field12\":38.4,\"grid_headcell_field2\":166.4,\"grid_headcell_field3\":63.4,\"grid_headcell_field11\":63.4,\"grid_headcell_field4\":52.4,\"grid_headcell_field5\":71.4,\"grid_headcell_field7\":49.4,\"grid_headcell_field9\":64.4,\"grid_headcell_field1\":58.4,\"grid_headcell_field10\":84.4,\"grid_headcell_field6\":47.4}}','tasks'),
 (5,2,NULL,'user2',NULL,'{\"gridWidth\":1192.4,\"thWidths\":{\"grid_headcell_icons\":27.4,\"grid_headcell_checkbox\":19.4,\"grid_headcell_details\":105.4,\"grid_headcell_field\":44.4,\"grid_headcell_field8\":28.4,\"grid_headcell_field12\":50.4,\"grid_headcell_field2\":171.4,\"grid_headcell_field3\":63.4,\"grid_headcell_field11\":63.4,\"grid_headcell_field4\":53.4,\"grid_headcell_field5\":72.4,\"grid_headcell_field7\":50.4,\"grid_headcell_field9\":67.4,\"grid_headcell_field1\":67.4,\"grid_headcell_field10\":76.4,\"grid_headcell_field6\":48.4}}','tasks'),
 (6,2,NULL,'admin',NULL,'{\"gridWidth\":1289.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":12.399999999999999,\"grid_headcell_details\":114.4,\"grid_headcell_details1\":39.4,\"grid_headcell_field\":10.399999999999999,\"grid_headcell_field11\":30.4,\"grid_headcell_field2\":0.3999999999999986,\"grid_headcell_field10\":45.4,\"grid_headcell_field3\":15.399999999999999,\"grid_headcell_field12\":354.4,\"grid_headcell_field4\":67.4,\"grid_headcell_field1\":117.4,\"grid_headcell_field5\":63.4,\"grid_headcell_field6\":63.4,\"grid_headcell_field7\":63.4,\"grid_headcell_field8\":39.4,\"grid_headcell_field9\":40.4}}','projects'),
 (7,2,NULL,'user2',NULL,'{\"gridWidth\":1260.4,\"thWidths\":{\"grid_headcell_icons\":18.4,\"grid_headcell_details\":45.4,\"grid_headcell_details1\":39.4,\"grid_headcell_field\":10.399999999999999,\"grid_headcell_field11\":30.4,\"grid_headcell_field1\":87.4,\"grid_headcell_field2\":94.4,\"grid_headcell_field10\":45.4,\"grid_headcell_field3\":15.399999999999999,\"grid_headcell_field12\":307.4,\"grid_headcell_field4\":67.4,\"grid_headcell_field5\":63.4,\"grid_headcell_field6\":64.4,\"grid_headcell_field7\":91.4,\"grid_headcell_field8\":39.4,\"grid_headcell_field9\":54.4}}','projects'),
 (8,3,'0','user2',NULL,'[\".dummyField\"]','projects'),
 (9,2,NULL,'user1',NULL,'{\"gridWidth\":1296.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_details\":50.4,\"grid_headcell_details1\":34.4,\"grid_headcell_field\":10.399999999999999,\"grid_headcell_field11\":30.4,\"grid_headcell_field1\":103.4,\"grid_headcell_field2\":94.4,\"grid_headcell_field10\":70.4,\"grid_headcell_field3\":15.399999999999999,\"grid_headcell_field12\":323.4,\"grid_headcell_field4\":39.4,\"grid_headcell_field5\":63.4,\"grid_headcell_field6\":63.4,\"grid_headcell_field7\":94.4,\"grid_headcell_field8\":37.4,\"grid_headcell_field9\":54.4}}','projects'),
 (10,2,NULL,'admin',NULL,'{\"gridWidth\":1085.4,\"thWidths\":{\"grid_headcell_icons\":21.4,\"grid_headcell_checkbox\":23.4,\"grid_headcell_field\":13.399999999999999,\"grid_headcell_field1\":28.4,\"grid_headcell_field2\":49.4,\"grid_headcell_field3\":86.4,\"grid_headcell_field4\":168.4,\"grid_headcell_field5\":77.4,\"grid_headcell_field6\":70.4,\"grid_headcell_field12\":63.4,\"grid_headcell_field7\":52.4,\"grid_headcell_field8\":82.4,\"grid_headcell_field9\":53.4,\"grid_headcell_field10\":75.4,\"grid_headcell_field11\":46.4}}','v_tasks'),
 (11,4,NULL,'admin',NULL,'[\"task_id\",\"flag\",\"problem\",\"short_name\",\"name\",\"start_date\",\"end_date\",\"actual_end_date\",\"duration\",\"duration_type\",\"percent_complete\",\"natural_days\",\"creator\"]','v_tasks'),
 (12,2,NULL,'user1',NULL,'{\"gridWidth\":1143.4,\"thWidths\":{\"grid_headcell_icons\":18.4,\"grid_headcell_checkbox\":18.4,\"grid_headcell_field\":13.399999999999999,\"grid_headcell_field1\":23.4,\"grid_headcell_field2\":49.4,\"grid_headcell_field3\":70.4,\"grid_headcell_field4\":267.4,\"grid_headcell_field5\":63.4,\"grid_headcell_field6\":63.4,\"grid_headcell_field12\":74.4,\"grid_headcell_field7\":52.4,\"grid_headcell_field8\":84.4,\"grid_headcell_field9\":54.4,\"grid_headcell_field10\":77.4,\"grid_headcell_field11\":39.4}}','v_tasks'),
 (13,4,NULL,'user1',NULL,'[\"task_id\",\"flag\",\"problem\",\"short_name\",\"name\",\"start_date\",\"end_date\",\"actual_end_date\",\"duration\",\"duration_type\",\"percent_complete\",\"natural_days\",\"creator\"]','v_tasks'),
 (14,2,NULL,'user2',NULL,'{\"gridWidth\":1169.4,\"thWidths\":{\"grid_headcell_icons\":18.4,\"grid_headcell_checkbox\":18.4,\"grid_headcell_field\":13.399999999999999,\"grid_headcell_field1\":23.4,\"grid_headcell_field2\":49.4,\"grid_headcell_field3\":70.4,\"grid_headcell_field4\":273.4,\"grid_headcell_field5\":63.4,\"grid_headcell_field6\":63.4,\"grid_headcell_field12\":94.4,\"grid_headcell_field7\":52.4,\"grid_headcell_field8\":84.4,\"grid_headcell_field9\":54.4,\"grid_headcell_field10\":77.4,\"grid_headcell_field11\":39.4}}','v_tasks'),
 (15,4,NULL,'user2',NULL,'[\"task_id\",\"flag\",\"problem\",\"short_name\",\"name\",\"start_date\",\"end_date\",\"actual_end_date\",\"duration\",\"duration_type\",\"percent_complete\",\"natural_days\",\"creator\"]','v_tasks'),
 (16,2,NULL,'admin',NULL,'{\"gridWidth\":905.4,\"thWidths\":{\"grid_headcell_icons\":18.4,\"grid_headcell_field8\":13.399999999999999,\"grid_headcell_field12\":27.4,\"grid_headcell_field2\":145.4,\"grid_headcell_field3\":67.4,\"grid_headcell_field11\":63.4,\"grid_headcell_field4\":53.4,\"grid_headcell_field5\":64.4,\"grid_headcell_field7\":46.4,\"grid_headcell_field9\":69.4,\"grid_headcell_field1\":67.4,\"grid_headcell_field10\":75.4,\"grid_headcell_field6\":44.4}}','v_timeline'),
 (17,2,NULL,'admin',NULL,'{\"gridWidth\":1268.4,\"thWidths\":{\"grid_headcell_icons\":11.399999999999999,\"grid_headcell_checkbox\":12.399999999999999,\"grid_headcell_field\":27.4,\"grid_headcell_field2\":23.4,\"grid_headcell_field3\":96.4,\"grid_headcell_field4\":48.4,\"grid_headcell_field5\":73.4,\"grid_headcell_field6\":64.4,\"grid_headcell_field7\":53.4,\"grid_headcell_field8\":81.4,\"grid_headcell_field9\":54.4,\"grid_headcell_field10\":67.4,\"grid_headcell_field11\":91.4,\"grid_headcell_field12\":149.4,\"grid_headcell_field13\":43.4,\"grid_headcell_field14\":78.4,\"grid_headcell_field15\":96.4}}','v_resource'),
 (18,3,'0','admin',NULL,'[\".dummyField\"]','tasks'),
 (19,2,NULL,'admin',NULL,'{\"gridWidth\":1051.4,\"thWidths\":{\"grid_headcell_icons\":22.4,\"grid_headcell_field\":13.399999999999999,\"grid_headcell_field10\":100.4,\"grid_headcell_field12\":113.4,\"grid_headcell_field11\":36.4,\"grid_headcell_field1\":110.4,\"grid_headcell_field2\":147.4,\"grid_headcell_field9\":73.4,\"grid_headcell_field3\":13.399999999999999,\"grid_headcell_field4\":46.4,\"grid_headcell_field7\":110.4,\"grid_headcell_field6\":73.4,\"grid_headcell_field8\":44.4,\"grid_headcell_field5\":106.4}}','v_projects'),
 (20,4,NULL,'admin',NULL,'[\"project_id\",\"short_name\",\"name\",\"color_identifier\",\"companies_company_id\",\"departments_dept_id\",\"percent_complete\",\"problem\",\"owner\",\"actual_end_date\",\"end_date\",\"status\",\"start_date\"]','v_projects'),
 (21,3,'0','admin',NULL,'[\".dummyField\",\"companies_company_id\"]','v_projects');
/*!40000 ALTER TABLE `project_settings` ENABLE KEYS */;


--
-- Definition of table `project_uggroups`
--

DROP TABLE IF EXISTS `project_uggroups`;
CREATE TABLE `project_uggroups` (
  `GroupID` int(11) NOT NULL AUTO_INCREMENT,
  `Label` varchar(300) DEFAULT NULL,
  `Provider` varchar(10) NOT NULL DEFAULT '',
  `Comment` mediumtext,
  PRIMARY KEY (`GroupID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `project_uggroups`
--

/*!40000 ALTER TABLE `project_uggroups` DISABLE KEYS */;
INSERT INTO `project_uggroups` (`GroupID`,`Label`,`Provider`,`Comment`) VALUES 
 (1,'Manager','',NULL);
/*!40000 ALTER TABLE `project_uggroups` ENABLE KEYS */;


--
-- Definition of table `project_ugmembers`
--

DROP TABLE IF EXISTS `project_ugmembers`;
CREATE TABLE `project_ugmembers` (
  `UserName` varchar(255) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `Provider` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`UserName`,`GroupID`,`Provider`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `project_ugmembers`
--

/*!40000 ALTER TABLE `project_ugmembers` DISABLE KEYS */;
INSERT INTO `project_ugmembers` (`UserName`,`GroupID`,`Provider`) VALUES 
 ('admin',-1,''),
 ('humanes',1,''),
 ('user1',1,''),
 ('user2',1,'');
/*!40000 ALTER TABLE `project_ugmembers` ENABLE KEYS */;


--
-- Definition of table `project_ugrights`
--

DROP TABLE IF EXISTS `project_ugrights`;
CREATE TABLE `project_ugrights` (
  `TableName` varchar(300) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `AccessMask` varchar(10) DEFAULT NULL,
  `Page` mediumtext,
  PRIMARY KEY (`TableName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `project_ugrights`
--

/*!40000 ALTER TABLE `project_ugrights` DISABLE KEYS */;
INSERT INTO `project_ugrights` (`TableName`,`GroupID`,`AccessMask`,`Page`) VALUES 
 ('catalog',-2,'S',NULL),
 ('catalog',-1,'AEDSPI',NULL),
 ('catalog',1,'SP',NULL),
 ('companies',-2,'SP',NULL),
 ('companies',-1,'ADESPIM',NULL),
 ('companies',1,'S',NULL),
 ('config',-2,'S',NULL),
 ('config',-1,'ADESPIM',NULL),
 ('config',1,'SP',NULL),
 ('contacts',-2,'S',NULL),
 ('contacts',-1,'ADESPIM',NULL),
 ('contacts',1,'AES',NULL),
 ('departments',-2,'SP',NULL),
 ('departments',-1,'ADESPIM',NULL),
 ('departments',1,'S',NULL),
 ('files',-2,'S',NULL),
 ('files',-1,'DESPIM',''),
 ('files',1,'DES',''),
 ('holidays',-2,'S',''),
 ('holidays',-1,'ADESPI',''),
 ('holidays',1,'SP',''),
 ('lv_catalog',-2,'S',NULL),
 ('lv_catalog',1,'S',NULL),
 ('lv_type',-2,'S',NULL),
 ('lv_type',1,'S',NULL),
 ('projects',-2,'SP',NULL),
 ('projects',-1,'ADESPIM',NULL),
 ('projects',1,'AES',NULL),
 ('super_catalog',-2,'S',NULL),
 ('super_catalog',-1,'AEDSPI',NULL),
 ('super_catalog',1,'S',NULL),
 ('super_type',-2,'S',NULL),
 ('super_type',-1,'AEDSPI',NULL),
 ('super_type',1,'SP',NULL),
 ('tasks',-2,'S',NULL),
 ('tasks',-1,'ADESPIM',NULL),
 ('tasks',1,'AEDS',NULL),
 ('task_log',-2,'S',NULL),
 ('task_log',-1,'DESPIM',NULL),
 ('task_log',1,'DES',''),
 ('type',-2,'S',NULL),
 ('type',-1,'AEDSPI',NULL),
 ('type',1,'SP',NULL),
 ('users',-2,'S',NULL),
 ('users',-1,'ADESPIM',NULL),
 ('users',1,'S',NULL),
 ('user_tasks',-2,'S',NULL),
 ('user_tasks',-1,'DESPIM',''),
 ('user_tasks',1,'DES',''),
 ('user_task_pin',-2,'S',NULL),
 ('user_task_pin',-1,'ADESPIM',NULL),
 ('v_projects',-2,'S',''),
 ('v_projects',-1,'S',''),
 ('v_projects',1,'S',''),
 ('v_resource',-2,'SP',''),
 ('v_resource',-1,'SP',''),
 ('v_resource',1,'SP',''),
 ('v_tasks',-2,'SP',''),
 ('v_tasks',-1,'SP',''),
 ('v_tasks',1,'SP',''),
 ('v_timeline',-2,'S',''),
 ('v_timeline',-1,'S',''),
 ('v_timeline',1,'S','');
/*!40000 ALTER TABLE `project_ugrights` ENABLE KEYS */;


--
-- Definition of table `projects`
--

DROP TABLE IF EXISTS `projects`;
CREATE TABLE `projects` (
  `project_id` int(10) NOT NULL AUTO_INCREMENT,
  `companies_company_id` int(10) NOT NULL,
  `departments_dept_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `short_name` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `owner` int(10) NOT NULL DEFAULT '0',
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `demo_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `actual_end_date` datetime DEFAULT NULL,
  `status` int(10) DEFAULT '0',
  `percent_complete` tinyint(4) DEFAULT '0',
  `color_identifier` varchar(7) COLLATE utf8_unicode_ci DEFAULT '#FFFFFF',
  `description` mediumtext COLLATE utf8_unicode_ci,
  `scheduled_hours` float NOT NULL DEFAULT '0',
  `worked_hours` float NOT NULL DEFAULT '0',
  `creator` int(10) DEFAULT '0',
  `private` int(10) unsigned DEFAULT '0',
  `contacts` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'deprecated',
  `active` int(1) NOT NULL DEFAULT '1',
  `project_parent` int(10) unsigned NOT NULL DEFAULT '0',
  `project_updator` int(10) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `updated` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `status_comment` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `end_date_adjusted_user` int(10) NOT NULL DEFAULT '0',
  `location` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`project_id`),
  KEY `idx_project_owner` (`owner`),
  KEY `project_name` (`name`),
  KEY `project_short_name` (`short_name`),
  KEY `project_start_date` (`start_date`),
  KEY `project_end_date` (`end_date`),
  KEY `project_status` (`status`),
  KEY `project_creator` (`creator`),
  KEY `project_parent` (`project_parent`),
  KEY `fk_projects_companies_idx` (`companies_company_id`),
  KEY `fk_projects_departments1_idx` (`departments_dept_id`),
  CONSTRAINT `fk_projects_companies` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_projects_departments1` FOREIGN KEY (`departments_dept_id`) REFERENCES `departments` (`dept_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `projects`
--

/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
INSERT INTO `projects` (`project_id`,`companies_company_id`,`departments_dept_id`,`name`,`short_name`,`owner`,`url`,`demo_url`,`start_date`,`end_date`,`actual_end_date`,`status`,`percent_complete`,`color_identifier`,`description`,`scheduled_hours`,`worked_hours`,`creator`,`private`,`contacts`,`active`,`project_parent`,`project_updator`,`created`,`updated`,`status_comment`,`end_date_adjusted_user`,`location`) VALUES 
 (2,3,1,'This example has been updated to check the new features.','P19/001',1,'','','2022-01-25','2022-08-21','2023-03-20 17:00:00',0,23,'#C90E9D','',628,44,1,1,'2',0,0,1,'2019-07-24 18:57:42','2023-01-31 18:57:11','',1,''),
 (3,3,1,'2º Project','P22/002',1,'','','2023-01-13','2023-05-25','2023-02-09 17:00:00',0,0,'#0815A3','Pruebas del desarrollo y control de varios proyectos',144,0,1,3,'',0,2,1,'2019-08-18 14:16:24','2023-01-31 19:20:32','',1,'');
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;


--
-- Definition of table `super_catalog`
--

DROP TABLE IF EXISTS `super_catalog`;
CREATE TABLE `super_catalog` (
  `idsuper_catalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idsuper_catalog`),
  UNIQUE KEY `super_catalog_ixd1` (`super_code`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `super_catalog`
--

/*!40000 ALTER TABLE `super_catalog` DISABLE KEYS */;
INSERT INTO `super_catalog` (`idsuper_catalog`,`super_code`,`description`) VALUES 
 (1,'PS','Project Status'),
 (2,'PP','Project Private'),
 (3,'PA','Project Active'),
 (4,'TD','Task Duration Type'),
 (5,'TY','Task Dynamic'),
 (6,'TN','Task Notify'),
 (7,'TA','Task Access'),
 (8,'TS','Task Status'),
 (9,'TUP','Tasks Users Priority'),
 (10,'TP','Tasks Pinned'),
 (11,'TM','Tasks Milestone'),
 (12,'TC','Task Completed'),
 (13,'CP','Companies Private'),
 (14,'TF','Task Flag');
/*!40000 ALTER TABLE `super_catalog` ENABLE KEYS */;


--
-- Definition of table `super_type`
--

DROP TABLE IF EXISTS `super_type`;
CREATE TABLE `super_type` (
  `idsuper_type` int(11) NOT NULL AUTO_INCREMENT,
  `super_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idsuper_type`),
  UNIQUE KEY `super_type_ixd1` (`super_code`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `super_type`
--

/*!40000 ALTER TABLE `super_type` DISABLE KEYS */;
INSERT INTO `super_type` (`idsuper_type`,`super_code`,`description`) VALUES 
 (1,'C','Companies'),
 (2,'D','Departaments'),
 (3,'P','Projects'),
 (4,'T','Tasks'),
 (5,'U','Users'),
 (6,'N','Contacts'),
 (7,'G','Config'),
 (8,'UT','Users Tasks');
/*!40000 ALTER TABLE `super_type` ENABLE KEYS */;


--
-- Definition of table `task_log`
--

DROP TABLE IF EXISTS `task_log`;
CREATE TABLE `task_log` (
  `task_log_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `description` mediumtext,
  `creator` int(10) NOT NULL,
  `created` datetime NOT NULL,
  `updator` int(10) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `hours` float NOT NULL DEFAULT '0',
  `date_day` date NOT NULL,
  `percent_complete` int(11) NOT NULL DEFAULT '0',
  `task_end_date` datetime DEFAULT NULL,
  `problem` int(11) DEFAULT '0',
  `related_url` varchar(255) DEFAULT NULL,
  `tasks_task_id` int(10) NOT NULL,
  PRIMARY KEY (`task_log_id`) USING BTREE,
  KEY `task_log_creator` (`creator`),
  KEY `task_log_date` (`date_day`),
  KEY `task_log_problem` (`problem`),
  KEY `fk_task_log_tasks1_idx` (`tasks_task_id`),
  CONSTRAINT `fk_task_log_tasks1` FOREIGN KEY (`tasks_task_id`) REFERENCES `tasks` (`task_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `task_log`
--

/*!40000 ALTER TABLE `task_log` DISABLE KEYS */;
INSERT INTO `task_log` (`task_log_id`,`name`,`description`,`creator`,`created`,`updator`,`updated`,`hours`,`date_day`,`percent_complete`,`task_end_date`,`problem`,`related_url`,`tasks_task_id`) VALUES 
 (71,'Informe semanal','',1,'2022-01-21 20:12:49',1,'2022-01-21 20:12:49',10,'2022-01-21',25,'2022-02-11 00:00:00',0,'',4),
 (72,'Marcado de problema','Descripción del problema',5,'2022-01-23 19:56:25',5,'2022-01-24 12:54:40',10,'2022-01-23',10,'2022-02-01 00:00:00',1,'',2),
 (73,'.','',1,'2022-01-24 12:58:17',1,'2022-01-24 12:58:17',14,'2022-01-24',15,'2022-03-03 00:00:00',0,'',16),
 (74,'.','',1,'2022-01-28 20:35:37',1,'2022-01-28 20:35:37',5,'2022-01-28',25,'2022-02-11 00:00:00',0,'',4),
 (75,'.','',1,'2022-01-28 20:59:29',1,'2022-01-28 20:59:29',1,'2022-01-28',25,'2022-02-11 00:00:00',0,'',4),
 (76,'.','',5,'2022-01-30 19:49:22',5,'2022-01-30 19:49:22',4,'2022-01-30',5,'2022-02-28 00:00:00',0,'',15),
 (77,'fINALIZADA','',5,'2022-01-31 13:31:56',5,'2022-01-31 13:31:56',0,'2022-01-31',100,'2022-01-31 00:00:00',0,'',4);
/*!40000 ALTER TABLE `task_log` ENABLE KEYS */;


--
-- Definition of table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
CREATE TABLE `tasks` (
  `task_id` int(10) NOT NULL AUTO_INCREMENT,
  `projects_project_id` int(10) NOT NULL,
  `parent` int(10) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `milestone` tinyint(1) DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `duration` float unsigned DEFAULT '0',
  `duration_type` int(10) NOT NULL DEFAULT '1',
  `hours_worked` float unsigned NOT NULL DEFAULT '0',
  `end_date` datetime DEFAULT NULL,
  `actual_end_date` datetime DEFAULT NULL,
  `status` int(10) DEFAULT '0',
  `percent_complete` int(11) DEFAULT '0',
  `description` longtext,
  `related_url` varchar(255) DEFAULT NULL,
  `creator` int(10) NOT NULL DEFAULT '0',
  `order` int(10) NOT NULL DEFAULT '0',
  `level` int(10) NOT NULL DEFAULT '0',
  `dynamic` int(11) NOT NULL DEFAULT '0',
  `access` int(10) NOT NULL DEFAULT '0',
  `notify` int(10) NOT NULL DEFAULT '0',
  `dependent` int(10) DEFAULT NULL,
  `contacts` varchar(100) DEFAULT NULL,
  `custom` longtext NOT NULL,
  `type` int(11) NOT NULL DEFAULT '0',
  `updator` int(10) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  PRIMARY KEY (`task_id`),
  KEY `idx_task1` (`start_date`),
  KEY `idx_task2` (`end_date`),
  KEY `task_name` (`name`),
  KEY `task_start_date` (`start_date`),
  KEY `task_end_date` (`end_date`),
  KEY `task_status` (`status`),
  KEY `task_creator` (`creator`),
  KEY `task_order` (`order`),
  KEY `task_type` (`type`),
  KEY `task_updator` (`updator`),
  KEY `fk_tasks_projects1_idx` (`projects_project_id`),
  KEY `fk_tasks_tasks1_idx` (`parent`),
  KEY `fk_tasks_tasks2_idx` (`dependent`),
  CONSTRAINT `fk_tasks_projects1` FOREIGN KEY (`projects_project_id`) REFERENCES `projects` (`project_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_tasks_tasks1` FOREIGN KEY (`parent`) REFERENCES `tasks` (`task_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_tasks_tasks2` FOREIGN KEY (`dependent`) REFERENCES `tasks` (`task_id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `tasks`
--

/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
INSERT INTO `tasks` (`task_id`,`projects_project_id`,`parent`,`name`,`milestone`,`start_date`,`duration`,`duration_type`,`hours_worked`,`end_date`,`actual_end_date`,`status`,`percent_complete`,`description`,`related_url`,`creator`,`order`,`level`,`dynamic`,`access`,`notify`,`dependent`,`contacts`,`custom`,`type`,`updator`,`created`,`updated`) VALUES 
 (1,2,NULL,'1.- Task 1',0,'2023-01-24 08:00:00',27,0,0,'2023-03-01 17:00:00',NULL,0,53,'dedede','',1,1,1,1,1,0,NULL,'',' ',0,1,'2019-07-25 00:00:00','2022-01-20 21:23:39'),
 (2,2,NULL,'2.- Task 2',0,'2023-01-26 08:00:00',36,1,10,'2023-02-01 17:00:00',NULL,0,10,'dedededede\r\nfrfr \'prueba\'\r\nfrffreee\r\ntttttt','',5,6,1,0,4,0,NULL,'','',0,1,'2019-08-14 14:38:40','2023-01-30 20:08:21'),
 (4,2,1,'1.1.- Task 1.1',0,'2023-01-24 08:00:00',15,0,16,'2023-02-13 17:00:00','2022-01-31 00:00:00',0,100,'','',1,2,2,0,1,0,NULL,'','',0,1,'2019-08-14 23:55:47','2023-01-30 20:07:29'),
 (5,2,1,'1.2.- Task 1.2',0,'2023-02-08 08:00:00',16,0,0,'2023-03-01 17:00:00',NULL,0,9,'Prueba de ....','',1,3,2,1,1,0,NULL,'','',0,1,'2019-08-17 16:05:59','2022-01-24 13:10:51'),
 (6,2,NULL,'3.- Task 3',0,'2023-01-28 08:00:00',26,0,30,'2023-03-06 17:00:00',NULL,0,0,'','',1,7,1,1,1,0,NULL,'','',0,5,'2019-08-17 16:08:56','2019-08-24 20:13:18'),
 (7,2,6,'3.1.- Task 3.1',0,'2023-02-21 08:00:00',10,0,0,'2023-03-06 17:00:00',NULL,0,0,'','',1,9,2,0,1,0,NULL,'','',0,1,'2019-08-17 16:09:45','2023-01-30 20:08:41'),
 (8,2,6,'3.2.- Task 3.2',0,'2023-01-28 08:00:00',3,0,0,'2023-01-31 17:00:00',NULL,0,0,'frfrfrfr','',1,8,2,0,1,0,NULL,'','',0,1,'2019-08-17 16:10:18','2023-01-30 20:08:30'),
 (11,3,NULL,'1.- Task',0,'2023-01-19 08:00:00',5,0,0,'2023-01-25 17:00:00',NULL,0,0,'','',1,1,1,0,4,0,NULL,'','',0,1,'2019-08-18 20:02:25','2023-01-30 20:10:55'),
 (12,3,NULL,'2.- Task',0,'2023-01-24 08:00:00',13,0,0,'2023-02-09 17:00:00',NULL,0,0,'','',1,2,1,0,3,0,NULL,'','',0,1,'2022-01-20 20:49:42','2023-01-31 19:59:08'),
 (13,2,NULL,'4.- Task 4',0,'2023-03-01 08:00:00',14,0,0,'2023-03-20 17:00:00',NULL,0,0,'','',1,10,1,0,3,0,NULL,'','',0,1,'2022-01-21 20:09:05','2023-01-30 20:09:07'),
 (14,2,NULL,'5.- Task 5',0,'2023-03-07 08:00:00',5,0,0,'2023-03-13 17:00:00',NULL,0,0,'','',5,11,1,0,4,0,NULL,'','',0,1,'2022-01-23 19:34:21','2023-01-30 20:09:16'),
 (15,2,5,'1.2.1.- Task 1.2.1',0,'2023-02-08 08:00:00',15,0,4,'2023-02-28 17:00:00',NULL,0,5,'Ejemplo de 3º nivel','',1,4,3,0,4,0,2,'','',0,1,'2022-01-24 12:56:02','2023-01-30 20:07:51'),
 (16,2,5,'1.2.2.- Task 1.2.2',0,'2023-02-14 08:00:00',12,0,14,'2023-03-01 17:00:00',NULL,0,15,'Description task 1.2.2','',1,5,3,0,4,0,NULL,'','',0,1,'2022-01-24 12:57:21','2023-01-30 20:08:07');
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;


--
-- Definition of table `type`
--

DROP TABLE IF EXISTS `type`;
CREATE TABLE `type` (
  `idtype` int(11) NOT NULL AUTO_INCREMENT,
  `super_type_idsuper_type` int(11) NOT NULL,
  `type_num` int(11) NOT NULL DEFAULT '0',
  `type_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idtype`),
  UNIQUE KEY `type_ixd1` (`super_type_idsuper_type`,`type_num`),
  KEY `fk_type_super_type1_idx` (`super_type_idsuper_type`),
  CONSTRAINT `fk_type_super_type1` FOREIGN KEY (`super_type_idsuper_type`) REFERENCES `super_type` (`idsuper_type`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `type`
--

/*!40000 ALTER TABLE `type` DISABLE KEYS */;
INSERT INTO `type` (`idtype`,`super_type_idsuper_type`,`type_num`,`type_code`,`description`) VALUES 
 (1,1,0,'S/A','Sin Asignar'),
 (2,2,0,'S/A','Sin Asignar'),
 (3,3,0,'S/A','Sin Asignar'),
 (4,4,0,'S/A','Sin Asignar'),
 (5,5,0,'S/A','Sin Asignar'),
 (6,6,0,'S/A','Sin Asignar'),
 (7,7,0,'S/A','Sin Asignar'),
 (8,8,0,'S/A','Sin Asignar');
/*!40000 ALTER TABLE `type` ENABLE KEYS */;


--
-- Definition of table `user_task_pin`
--

DROP TABLE IF EXISTS `user_task_pin`;
CREATE TABLE `user_task_pin` (
  `user_task_pin_id` int(11) NOT NULL AUTO_INCREMENT,
  `users_user_id` int(10) NOT NULL,
  `tasks_task_id` int(10) NOT NULL,
  `task_pinned` tinyint(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`user_task_pin_id`),
  KEY `fk_user_task_pin_users1_idx` (`users_user_id`),
  KEY `fk_user_task_pin_tasks1_idx` (`tasks_task_id`),
  CONSTRAINT `fk_user_task_pin_tasks1` FOREIGN KEY (`tasks_task_id`) REFERENCES `tasks` (`task_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `fk_user_task_pin_users1` FOREIGN KEY (`users_user_id`) REFERENCES `users` (`user_id`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `user_task_pin`
--

/*!40000 ALTER TABLE `user_task_pin` DISABLE KEYS */;
INSERT INTO `user_task_pin` (`user_task_pin_id`,`users_user_id`,`tasks_task_id`,`task_pinned`) VALUES 
 (1,1,1,0);
/*!40000 ALTER TABLE `user_task_pin` ENABLE KEYS */;


--
-- Definition of table `user_tasks`
--

DROP TABLE IF EXISTS `user_tasks`;
CREATE TABLE `user_tasks` (
  `user_task_id` int(11) NOT NULL AUTO_INCREMENT,
  `users_user_id` int(10) NOT NULL,
  `tasks_task_id` int(10) NOT NULL,
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `perc_assignment` int(10) NOT NULL DEFAULT '100',
  `user_task_priority` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`user_task_id`),
  KEY `fk_user_tasks_users1_idx` (`users_user_id`),
  KEY `fk_user_tasks_tasks1_idx` (`tasks_task_id`),
  CONSTRAINT `fk_user_tasks_tasks1` FOREIGN KEY (`tasks_task_id`) REFERENCES `tasks` (`task_id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `fk_user_tasks_users1` FOREIGN KEY (`users_user_id`) REFERENCES `users` (`user_id`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `user_tasks`
--

/*!40000 ALTER TABLE `user_tasks` DISABLE KEYS */;
INSERT INTO `user_tasks` (`user_task_id`,`users_user_id`,`tasks_task_id`,`type`,`perc_assignment`,`user_task_priority`) VALUES 
 (1,1,1,0,15,0),
 (2,4,1,0,10,0),
 (3,1,4,0,25,0),
 (4,4,4,0,50,0),
 (8,1,15,0,25,0),
 (9,5,15,0,25,0),
 (10,4,15,0,25,0),
 (11,4,16,0,50,0),
 (12,1,16,0,15,0),
 (13,1,2,0,10,0),
 (14,5,2,0,50,0),
 (15,5,8,0,50,0),
 (16,4,8,0,50,0),
 (17,1,8,0,15,0),
 (18,5,7,0,25,0),
 (19,4,7,0,25,0),
 (20,1,7,0,10,0),
 (21,1,13,0,100,0),
 (22,1,14,0,10,0),
 (23,5,14,0,100,0);
/*!40000 ALTER TABLE `user_tasks` ENABLE KEYS */;


--
-- Definition of table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `user_id` int(10) NOT NULL AUTO_INCREMENT,
  `login` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `companies_company_id` int(10) NOT NULL DEFAULT '0',
  `departments_dept_id` int(10) unsigned DEFAULT NULL,
  `username` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `type` int(11) NOT NULL DEFAULT '0',
  `signature` mediumtext COLLATE utf8_unicode_ci,
  `reset_token` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reset_date` datetime DEFAULT NULL,
  `email` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'user@domain.com',
  PRIMARY KEY (`user_id`),
  KEY `user_username` (`username`),
  KEY `fk_users_companies1_idx` (`companies_company_id`),
  KEY `user_login` (`login`),
  CONSTRAINT `fk_users_companies1` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `users`
--

/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`user_id`,`login`,`companies_company_id`,`departments_dept_id`,`username`,`password`,`type`,`signature`,`reset_token`,`reset_date`,`email`) VALUES 
 (1,'admin',0,NULL,'Administrator','21232f297a57a5a743894a0e4a801fc3',0,'',NULL,NULL,'adminr@fhumanes.com'),
 (4,'user1',3,1,'Usuario 1','24c9e15e52afc47c225b757e7bee1f9d',0,'',NULL,NULL,'user1@fhumanes.com'),
 (5,'user2',4,2,'Usuario 2','7e58d63b60197ceb55a1c487989a3720',0,'',NULL,NULL,'user2@fhumanes.com');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;


--
-- Definition of function `TOTAL_WEEKDAYS`
--

DROP FUNCTION IF EXISTS `TOTAL_WEEKDAYS`;

DELIMITER $$

/*!50003 SET @TEMP_SQL_MODE=@@SQL_MODE, SQL_MODE='STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ $$
CREATE  FUNCTION `TOTAL_WEEKDAYS`(date1 DATE, date2 DATE) RETURNS int(11)
BEGIN
RETURN ABS(DATEDIFF(date2, date1)) + 1
     - ABS(DATEDIFF(ADDDATE(date2, INTERVAL 1 - DAYOFWEEK(date2) DAY),
                    ADDDATE(date1, INTERVAL 1 - DAYOFWEEK(date1) DAY))) / 7 * 2
     - (DAYOFWEEK(IF(date1 < date2, date1, date2)) = 1)
     - (DAYOFWEEK(IF(date1 > date2, date1, date2)) = 7);

END $$
/*!50003 SET SESSION SQL_MODE=@TEMP_SQL_MODE */  $$

DELIMITER ;



/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
